/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.stream;

import java.util.Arrays;
import java.util.Objects;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;

public abstract class AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_ extends Score<Score_>>
extends AbstractScoreDirectorFactory<Solution_, Score_> {
    protected AbstractConstraintStreamScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        super(solutionDescriptor);
    }

    protected Constraint[] buildConstraints(ConstraintProvider constraintProvider, InnerConstraintFactory<Solution_> constraintFactory) {
        Constraint[] constraints = constraintProvider.defineConstraints(constraintFactory);
        if (constraints == null) {
            throw new IllegalStateException("The constraintProvider class (" + constraintProvider.getClass() + ")'s defineConstraints() must not return null.\nMaybe return an empty array instead if there are no constraints.");
        }
        if (Arrays.stream(constraints).anyMatch(Objects::isNull)) {
            throw new IllegalStateException("The constraintProvider class (" + constraintProvider.getClass() + ")'s defineConstraints() must not contain an element that is null.\nMaybe don't include any null elements in the " + Constraint.class.getSimpleName() + " array.");
        }
        return constraints;
    }

    public abstract Constraint[] getConstraints();
}

