/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;

public class ScoreUtils {
    public static Score parseScore(Class<? extends Score<?>> scoreClass, String scoreString) {
        if (SimpleScore.class.equals(scoreClass)) {
            return SimpleScore.parseScore(scoreString);
        }
        if (SimpleLongScore.class.equals(scoreClass)) {
            return SimpleLongScore.parseScore(scoreString);
        }
        if (SimpleBigDecimalScore.class.equals(scoreClass)) {
            return SimpleBigDecimalScore.parseScore(scoreString);
        }
        if (HardSoftScore.class.equals(scoreClass)) {
            return HardSoftScore.parseScore(scoreString);
        }
        if (HardSoftLongScore.class.equals(scoreClass)) {
            return HardSoftLongScore.parseScore(scoreString);
        }
        if (HardSoftBigDecimalScore.class.equals(scoreClass)) {
            return HardSoftBigDecimalScore.parseScore(scoreString);
        }
        if (HardMediumSoftScore.class.equals(scoreClass)) {
            return HardMediumSoftScore.parseScore(scoreString);
        }
        if (HardMediumSoftLongScore.class.equals(scoreClass)) {
            return HardMediumSoftLongScore.parseScore(scoreString);
        }
        if (HardMediumSoftBigDecimalScore.class.equals(scoreClass)) {
            return HardMediumSoftBigDecimalScore.parseScore(scoreString);
        }
        if (BendableScore.class.equals(scoreClass)) {
            return BendableScore.parseScore(scoreString);
        }
        if (BendableLongScore.class.equals(scoreClass)) {
            return BendableLongScore.parseScore(scoreString);
        }
        if (BendableBigDecimalScore.class.equals(scoreClass)) {
            return BendableBigDecimalScore.parseScore(scoreString);
        }
        throw new IllegalArgumentException("Unrecognized scoreClass (" + scoreClass + ") for scoreString (" + scoreString + ").");
    }

    public static double[] extractLevelDoubles(Score score) {
        Number[] levelNumbers = score.toLevelNumbers();
        double[] levelDoubles = new double[levelNumbers.length];
        for (int i = 0; i < levelNumbers.length; ++i) {
            levelDoubles[i] = levelNumbers[i].doubleValue();
        }
        return levelDoubles;
    }

    public static double calculateTimeGradient(Number[] totalDiffNumbers, Number[] scoreDiffNumbers, double[] timeGradientWeightNumbers, int levelDepth) {
        double timeGradient = 0.0;
        double remainingTimeGradient = 1.0;
        for (int i = 0; i < levelDepth; ++i) {
            double levelTimeGradientWeight;
            if (i != levelDepth - 1) {
                levelTimeGradientWeight = remainingTimeGradient * timeGradientWeightNumbers[i];
                remainingTimeGradient -= levelTimeGradientWeight;
            } else {
                levelTimeGradientWeight = remainingTimeGradient;
                remainingTimeGradient = 0.0;
            }
            double totalDiffLevel = totalDiffNumbers[i].doubleValue();
            double scoreDiffLevel = scoreDiffNumbers[i].doubleValue();
            if (scoreDiffLevel == totalDiffLevel) {
                timeGradient += levelTimeGradientWeight;
                continue;
            }
            if (scoreDiffLevel > totalDiffLevel) {
                timeGradient += levelTimeGradientWeight + remainingTimeGradient;
                break;
            }
            if (scoreDiffLevel == 0.0) continue;
            if (scoreDiffLevel < 0.0) break;
            double levelTimeGradient = scoreDiffLevel / totalDiffLevel;
            timeGradient += levelTimeGradient * levelTimeGradientWeight;
        }
        if (timeGradient > 1.0) {
            timeGradient = 1.0;
        }
        return timeGradient;
    }

    private ScoreUtils() {
    }
}

