/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor.gizmo;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.function.Consumer;
import org.objectweb.asm.Type;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;

public class GizmoMemberDescriptor {
    String name;
    Object memberDescriptor;
    Object metadataDescriptor;
    Class<?> declaringClass;
    Optional<MethodDescriptor> setter;

    public GizmoMemberDescriptor(Member member) {
        this.declaringClass = member.getDeclaringClass();
        if (!Modifier.isPublic(member.getModifiers())) {
            throw new IllegalStateException("Member (" + member.getName() + ") of class (" + member.getDeclaringClass().getName() + ") is not public and domainAccessType is GIZMO.\n" + (member instanceof Field ? "Maybe put the annotations onto the public getter of the field.\n" : "") + "Maybe use domainAccessType REFLECTION instead of GIZMO.");
        }
        if (member instanceof Field) {
            this.memberDescriptor = FieldDescriptor.of((Field)((Field)member));
            this.name = member.getName();
            this.setter = GizmoMemberDescriptor.lookupSetter(this.memberDescriptor, this.declaringClass, this.name);
        } else if (member instanceof Method) {
            this.memberDescriptor = MethodDescriptor.ofMethod((Method)((Method)member));
            this.name = ReflectionHelper.isGetterMethod((Method)member) ? ReflectionHelper.getGetterPropertyName(member) : member.getName();
            this.setter = GizmoMemberDescriptor.lookupSetter(this.memberDescriptor, this.declaringClass, this.name);
        } else {
            throw new IllegalArgumentException(member + " is not a Method or a Field.");
        }
        this.metadataDescriptor = this.memberDescriptor;
    }

    public GizmoMemberDescriptor(String name, Object memberDescriptor, Object metadataDescriptor, Class<?> declaringClass) {
        this(name, memberDescriptor, metadataDescriptor, declaringClass, GizmoMemberDescriptor.lookupSetter(memberDescriptor, declaringClass, name).orElse(null));
    }

    public GizmoMemberDescriptor(String name, Object memberDescriptor, Object metadataDescriptor, Class<?> declaringClass, MethodDescriptor setterDescriptor) {
        this.name = name;
        this.memberDescriptor = memberDescriptor;
        this.metadataDescriptor = metadataDescriptor;
        this.declaringClass = declaringClass;
        this.setter = Optional.ofNullable(setterDescriptor);
    }

    public GizmoMemberDescriptor whenIsField(Consumer<FieldDescriptor> fieldDescriptorConsumer) {
        if (this.memberDescriptor instanceof FieldDescriptor) {
            fieldDescriptorConsumer.accept((FieldDescriptor)this.memberDescriptor);
        }
        return this;
    }

    public GizmoMemberDescriptor whenIsMethod(Consumer<MethodDescriptor> methodDescriptorConsumer) {
        if (this.memberDescriptor instanceof MethodDescriptor) {
            methodDescriptorConsumer.accept((MethodDescriptor)this.memberDescriptor);
        }
        return this;
    }

    public ResultHandle readMemberValue(BytecodeCreator bytecodeCreator, ResultHandle thisObj) {
        if (this.memberDescriptor instanceof FieldDescriptor) {
            FieldDescriptor fd = (FieldDescriptor)this.memberDescriptor;
            return bytecodeCreator.readInstanceField(fd, thisObj);
        }
        if (this.memberDescriptor instanceof MethodDescriptor) {
            MethodDescriptor md = (MethodDescriptor)this.memberDescriptor;
            return this.invokeMemberMethod(bytecodeCreator, md, thisObj, new ResultHandle[0]);
        }
        throw new IllegalStateException("memberDescriptor (" + this.memberDescriptor + ") is neither a field descriptor or a method descriptor.");
    }

    public boolean writeMemberValue(BytecodeCreator bytecodeCreator, ResultHandle thisObj, ResultHandle newValue) {
        if (this.memberDescriptor instanceof FieldDescriptor) {
            FieldDescriptor fd = (FieldDescriptor)this.memberDescriptor;
            bytecodeCreator.writeInstanceField(fd, thisObj, newValue);
            return true;
        }
        if (this.memberDescriptor instanceof MethodDescriptor) {
            MethodDescriptor md = (MethodDescriptor)this.memberDescriptor;
            Optional<MethodDescriptor> maybeSetter = this.getSetter();
            if (!maybeSetter.isPresent()) {
                return false;
            }
            this.invokeMemberMethod(bytecodeCreator, maybeSetter.get(), thisObj, newValue);
            return true;
        }
        throw new IllegalStateException("memberDescriptor (" + this.memberDescriptor + ") is neither a field descriptor or a method descriptor.");
    }

    public GizmoMemberDescriptor whenMetadataIsOnField(Consumer<FieldDescriptor> fieldDescriptorConsumer) {
        if (this.metadataDescriptor instanceof FieldDescriptor) {
            fieldDescriptorConsumer.accept((FieldDescriptor)this.metadataDescriptor);
        }
        return this;
    }

    public GizmoMemberDescriptor whenMetadataIsOnMethod(Consumer<MethodDescriptor> methodDescriptorConsumer) {
        if (this.metadataDescriptor instanceof MethodDescriptor) {
            methodDescriptorConsumer.accept((MethodDescriptor)this.metadataDescriptor);
        }
        return this;
    }

    public String getDeclaringClassName() {
        if (this.memberDescriptor instanceof FieldDescriptor) {
            return ((FieldDescriptor)this.memberDescriptor).getDeclaringClass();
        }
        if (this.memberDescriptor instanceof MethodDescriptor) {
            return ((MethodDescriptor)this.memberDescriptor).getDeclaringClass();
        }
        throw new IllegalStateException("memberDescriptor not a fieldDescriptor or a methodDescriptor");
    }

    public boolean isInterfaceMethod() {
        if (this.memberDescriptor instanceof MethodDescriptor) {
            return this.declaringClass.isInterface();
        }
        return false;
    }

    public ResultHandle invokeMemberMethod(BytecodeCreator creator, MethodDescriptor method, ResultHandle bean, ResultHandle ... parameters) {
        if (this.isInterfaceMethod()) {
            return creator.invokeInterfaceMethod(method, bean, parameters);
        }
        return creator.invokeVirtualMethod(method, bean, parameters);
    }

    public Optional<MethodDescriptor> getSetter() {
        return this.setter;
    }

    private static Optional<MethodDescriptor> lookupSetter(Object memberDescriptor, Class<?> declaringClass, String name) {
        if (memberDescriptor instanceof MethodDescriptor) {
            return Optional.ofNullable(ReflectionHelper.getSetterMethod(declaringClass, name)).map(MethodDescriptor::ofMethod);
        }
        return Optional.empty();
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        String typeName = this.metadataDescriptor instanceof FieldDescriptor ? ((FieldDescriptor)this.metadataDescriptor).getType() : ((MethodDescriptor)this.metadataDescriptor).getReturnType();
        return Type.getType((String)typeName).getClassName();
    }

    public java.lang.reflect.Type getType() {
        if (this.metadataDescriptor instanceof FieldDescriptor) {
            FieldDescriptor fieldDescriptor = (FieldDescriptor)this.metadataDescriptor;
            try {
                return this.declaringClass.getDeclaredField(fieldDescriptor.getName()).getGenericType();
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Cannot find field (" + fieldDescriptor.getName() + ") on class (" + this.declaringClass + ").", e);
            }
        }
        MethodDescriptor methodDescriptor = (MethodDescriptor)this.metadataDescriptor;
        try {
            return this.declaringClass.getDeclaredMethod(methodDescriptor.getName(), new Class[0]).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Cannot find method (" + methodDescriptor.getName() + ") on class (" + this.declaringClass + ").", e);
        }
    }

    public String toString() {
        return this.memberDescriptor.toString();
    }
}

