/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import java.time.Clock;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;
import org.optaplanner.core.impl.util.Pair;

public class UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination<Solution_>
extends AbstractTermination<Solution_> {
    private final long unimprovedTimeMillisSpentLimit;
    private final Score unimprovedScoreDifferenceThreshold;
    private final Clock clock;
    private Queue<Pair<Long, Score>> bestScoreImprovementHistoryQueue;
    private long solverSafeTimeMillis = -1L;
    private long phaseSafeTimeMillis = -1L;

    public UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination(long unimprovedTimeMillisSpentLimit, Score unimprovedScoreDifferenceThreshold) {
        this(unimprovedTimeMillisSpentLimit, unimprovedScoreDifferenceThreshold, Clock.systemUTC());
    }

    protected UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination(long unimprovedTimeMillisSpentLimit, Score unimprovedScoreDifferenceThreshold, Clock clock) {
        this.unimprovedTimeMillisSpentLimit = unimprovedTimeMillisSpentLimit;
        this.unimprovedScoreDifferenceThreshold = unimprovedScoreDifferenceThreshold;
        if (unimprovedTimeMillisSpentLimit < 0L) {
            throw new IllegalArgumentException("The unimprovedTimeMillisSpentLimit (" + unimprovedTimeMillisSpentLimit + ") cannot be negative.");
        }
        this.clock = clock;
    }

    public long getUnimprovedTimeMillisSpentLimit() {
        return this.unimprovedTimeMillisSpentLimit;
    }

    public Score getUnimprovedScoreDifferenceThreshold() {
        return this.unimprovedScoreDifferenceThreshold;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        this.bestScoreImprovementHistoryQueue = new ArrayDeque<Pair<Long, Score>>();
        this.solverSafeTimeMillis = solverScope.getBestSolutionTimeMillis() + this.unimprovedTimeMillisSpentLimit;
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        this.bestScoreImprovementHistoryQueue = null;
        this.solverSafeTimeMillis = -1L;
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        this.phaseSafeTimeMillis = phaseScope.getStartingSystemTimeMillis() + this.unimprovedTimeMillisSpentLimit;
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        this.phaseSafeTimeMillis = -1L;
    }

    @Override
    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        if (stepScope.getBestScoreImproved().booleanValue()) {
            SolverScope<Solution_> solverScope = stepScope.getPhaseScope().getSolverScope();
            long bestSolutionTimeMillis = solverScope.getBestSolutionTimeMillis();
            Score bestScore = solverScope.getBestScore();
            Iterator it = this.bestScoreImprovementHistoryQueue.iterator();
            while (it.hasNext()) {
                long safeTimeMillis;
                boolean scoreImprovedOverThreshold;
                Pair bestScoreImprovement = (Pair)it.next();
                Score scoreDifference = bestScore.subtract((Score)bestScoreImprovement.getValue());
                boolean timeLimitNotYetReached = (Long)bestScoreImprovement.getKey() + this.unimprovedTimeMillisSpentLimit >= bestSolutionTimeMillis;
                boolean bl = scoreImprovedOverThreshold = scoreDifference.compareTo(this.unimprovedScoreDifferenceThreshold) >= 0;
                if (!scoreImprovedOverThreshold || !timeLimitNotYetReached) break;
                it.remove();
                this.solverSafeTimeMillis = safeTimeMillis = bestSolutionTimeMillis + this.unimprovedTimeMillisSpentLimit;
                this.phaseSafeTimeMillis = safeTimeMillis;
            }
            this.bestScoreImprovementHistoryQueue.add(Pair.of(bestSolutionTimeMillis, bestScore));
        }
    }

    @Override
    public boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        return this.isTerminated(this.solverSafeTimeMillis);
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        return this.isTerminated(this.phaseSafeTimeMillis);
    }

    protected boolean isTerminated(long safeTimeMillis) {
        long now = this.clock.millis();
        return now > safeTimeMillis;
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        return this.calculateTimeGradient(this.solverSafeTimeMillis);
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        return this.calculateTimeGradient(this.phaseSafeTimeMillis);
    }

    protected double calculateTimeGradient(long safeTimeMillis) {
        long now = this.clock.millis();
        long unimprovedTimeMillisSpent = now - (safeTimeMillis - this.unimprovedTimeMillisSpentLimit);
        double timeGradient = (double)unimprovedTimeMillisSpent / (double)this.unimprovedTimeMillisSpentLimit;
        return Math.min(timeGradient, 1.0);
    }

    @Override
    public UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return new UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination<Solution_>(this.unimprovedTimeMillisSpentLimit, this.unimprovedScoreDifferenceThreshold);
    }

    public String toString() {
        return "UnimprovedTimeMillisSpent(" + this.unimprovedTimeMillisSpentLimit + ")";
    }
}

