/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.tri;

import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.impl.score.stream.common.AbstractJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.tri.CompositeTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.SingleTriJoiner;

public abstract class AbstractTriJoiner<A, B, C>
extends AbstractJoiner
implements TriJoiner<A, B, C> {
    private final TriPredicate<A, B, C> filter;

    protected AbstractTriJoiner() {
        this.filter = null;
    }

    protected AbstractTriJoiner(TriPredicate<A, B, C> filter) {
        this.filter = filter;
    }

    @SafeVarargs
    public static <A, B, C> AbstractTriJoiner<A, B, C> merge(TriJoiner<A, B, C> ... joiners) {
        ArrayList joinerList = new ArrayList();
        for (TriJoiner<A, B, C> joiner : joiners) {
            if (joiner instanceof NoneTriJoiner) continue;
            if (joiner instanceof SingleTriJoiner) {
                joinerList.add((SingleTriJoiner)joiner);
                continue;
            }
            if (joiner instanceof CompositeTriJoiner) {
                joinerList.addAll(((CompositeTriJoiner)joiner).getJoinerList());
                continue;
            }
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        if (joinerList.isEmpty()) {
            return new NoneTriJoiner();
        }
        if (joinerList.size() == 1) {
            return (AbstractTriJoiner)joinerList.get(0);
        }
        return new CompositeTriJoiner(joinerList);
    }

    public boolean matches(A a, B b, C c) {
        JoinerType[] joinerTypes = this.getJoinerTypes();
        for (int i = 0; i < joinerTypes.length; ++i) {
            Object rightMapping;
            JoinerType joinerType = joinerTypes[i];
            Object leftMapping = this.getLeftMapping(i).apply(a, b);
            if (joinerType.matches(leftMapping, rightMapping = this.getRightMapping(i).apply(c))) continue;
            return false;
        }
        return true;
    }

    public abstract BiFunction<A, B, Object> getLeftMapping(int var1);

    public abstract BiFunction<A, B, Object[]> getLeftCombinedMapping();

    public abstract Function<C, Object> getRightMapping(int var1);

    public abstract Function<C, Object[]> getRightCombinedMapping();

    public TriPredicate<A, B, C> getFilter() {
        return this.filter;
    }
}

