/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.Tuple;
import org.optaplanner.core.impl.score.stream.drools.common.ValueExtractor;

abstract class AbstractAccumulator<ResultContainer_, Result_>
implements Accumulator {
    private final Supplier<ResultContainer_> containerSupplier;
    private final Function<ResultContainer_, Result_> finisher;
    private volatile boolean initialized = false;

    protected AbstractAccumulator(Supplier<ResultContainer_> containerSupplier, Function<ResultContainer_, Result_> finisher) {
        this.containerSupplier = Objects.requireNonNull(containerSupplier);
        this.finisher = Objects.requireNonNull(finisher);
    }

    protected static <X> Function<Tuple, X> getValueExtractor(Declaration declaration, Tuple leftTuple) {
        return new ValueExtractor(declaration, leftTuple);
    }

    public final Object createWorkingMemoryContext() {
        return null;
    }

    public final Object createContext() {
        return null;
    }

    public final ResultContainer_ init(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, ReteEvaluator reteEvaluator) {
        return this.containerSupplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, ReteEvaluator reteEvaluator) {
        if (!this.initialized) {
            AbstractAccumulator abstractAccumulator = this;
            synchronized (abstractAccumulator) {
                if (!this.initialized) {
                    this.initialize(leftTuple, innerDeclarations);
                    this.initialized = true;
                }
            }
        }
        return this.accumulate(context, leftTuple, handle, innerDeclarations);
    }

    protected abstract Runnable accumulate(ResultContainer_ var1, Tuple var2, InternalFactHandle var3, Declaration[] var4);

    protected abstract void initialize(Tuple var1, Declaration[] var2);

    public final boolean supportsReverse() {
        return true;
    }

    public final boolean tryReverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Object value, Declaration[] declarations, Declaration[] innerDeclarations, ReteEvaluator reteEvaluator) {
        ((Runnable)value).run();
        return true;
    }

    public final Result_ getResult(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, ReteEvaluator reteEvaluator) {
        return this.finisher.apply(context);
    }
}

