/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.common.index;

import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinBridgeTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.index.BavetEqualsAndComparisonIndex;
import org.optaplanner.core.impl.score.stream.bavet.common.index.BavetEqualsIndex;
import org.optaplanner.core.impl.score.stream.bavet.common.index.BavetIndex;
import org.optaplanner.core.impl.score.stream.bavet.common.index.BavetNoneIndex;
import org.optaplanner.core.impl.score.stream.common.AbstractJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;

public class BavetIndexFactory {
    private final JoinerType[] joinerTypes;

    public BavetIndexFactory(AbstractJoiner joiner) {
        this.joinerTypes = joiner.getJoinerTypes();
        for (int i = 0; i < this.joinerTypes.length; ++i) {
            if (this.joinerTypes[i] == JoinerType.EQUAL || i == this.joinerTypes.length - 1) continue;
            throw new IllegalArgumentException("The joinerType (" + this.joinerTypes[i] + ") is currently only supported as the last joinerType.\n" + (this.joinerTypes[i + 1] == JoinerType.EQUAL ? "Maybe move the next joinerType (" + this.joinerTypes[i + 1] + ") before this joinerType (" + this.joinerTypes[i] + ")." : "Maybe put the next joinerType (" + this.joinerTypes[i + 1] + ") in a filter() predicate after the join() call for now."));
        }
    }

    public <Tuple_ extends BavetJoinBridgeTuple> BavetIndex<Tuple_> buildIndex(boolean isLeftBridge) {
        if (this.joinerTypes.length == 0) {
            return new BavetNoneIndex();
        }
        JoinerType lastJoinerType = this.joinerTypes[this.joinerTypes.length - 1];
        if (lastJoinerType == JoinerType.EQUAL) {
            return new BavetEqualsIndex();
        }
        return new BavetEqualsAndComparisonIndex(isLeftBridge ? lastJoinerType : lastJoinerType.flip());
    }
}

