/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.localsearch.decider.forager.finalist;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.impl.localsearch.decider.forager.finalist.FinalistPodium;
import org.optaplanner.core.impl.localsearch.event.LocalSearchPhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchMoveScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchPhaseScope;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFinalistPodium<Solution_>
extends LocalSearchPhaseLifecycleListenerAdapter<Solution_>
implements FinalistPodium<Solution_> {
    protected static final int FINALIST_LIST_MAX_SIZE = 1024000;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean finalistIsAccepted;
    protected List<LocalSearchMoveScope<Solution_>> finalistList;

    @Override
    public void stepStarted(LocalSearchStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        this.finalistIsAccepted = false;
        this.finalistList = new ArrayList<LocalSearchMoveScope<Solution_>>(1024);
    }

    protected void clearAndAddFinalist(LocalSearchMoveScope<Solution_> moveScope) {
        this.finalistList.clear();
        this.finalistList.add(moveScope);
    }

    protected void addFinalist(LocalSearchMoveScope<Solution_> moveScope) {
        if (this.finalistList.size() >= 1024000) {
            return;
        }
        this.finalistList.add(moveScope);
    }

    @Override
    public List<LocalSearchMoveScope<Solution_>> getFinalistList() {
        return this.finalistList;
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.finalistIsAccepted = false;
        this.finalistList = null;
    }
}

