/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Objects;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class ChainedChangeMove<Solution_>
extends ChangeMove<Solution_> {
    protected final Object oldTrailingEntity;
    protected final Object newTrailingEntity;

    public ChainedChangeMove(Object entity, GenuineVariableDescriptor<Solution_> variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, Object toPlanningValue) {
        super(entity, variableDescriptor, toPlanningValue);
        this.oldTrailingEntity = inverseVariableSupply.getInverseSingleton(entity);
        this.newTrailingEntity = toPlanningValue == null ? null : inverseVariableSupply.getInverseSingleton(toPlanningValue);
    }

    public ChainedChangeMove(Object entity, GenuineVariableDescriptor<Solution_> variableDescriptor, Object toPlanningValue, Object oldTrailingEntity, Object newTrailingEntity) {
        super(entity, variableDescriptor, toPlanningValue);
        this.oldTrailingEntity = oldTrailingEntity;
        this.newTrailingEntity = newTrailingEntity;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return super.isMoveDoable(scoreDirector) && !Objects.equals(this.entity, this.toPlanningValue);
    }

    @Override
    public ChainedChangeMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        Object oldValue = this.variableDescriptor.getValue(this.entity);
        return new ChainedChangeMove<Solution_>(this.entity, this.variableDescriptor, oldValue, this.newTrailingEntity, this.oldTrailingEntity);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Object oldValue = this.variableDescriptor.getValue(this.entity);
        if (this.oldTrailingEntity != null) {
            innerScoreDirector.changeVariableFacade(this.variableDescriptor, this.oldTrailingEntity, oldValue);
        }
        innerScoreDirector.changeVariableFacade(this.variableDescriptor, this.entity, this.toPlanningValue);
        if (this.newTrailingEntity != null) {
            innerScoreDirector.changeVariableFacade(this.variableDescriptor, this.newTrailingEntity, this.entity);
        }
    }

    @Override
    public ChainedChangeMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new ChainedChangeMove<Solution_>(destinationScoreDirector.lookUpWorkingObject(this.entity), this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.toPlanningValue), destinationScoreDirector.lookUpWorkingObject(this.oldTrailingEntity), destinationScoreDirector.lookUpWorkingObject(this.newTrailingEntity));
    }
}

