/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.pillar;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.heuristic.selector.entity.pillar.PillarSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.entity.pillar.SubPillarConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.move.generic.SubPillarType;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.AbstractSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.DefaultPillarSelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.PillarSelector;

public class PillarSelectorFactory<Solution_>
extends AbstractSelectorFactory<Solution_, PillarSelectorConfig> {
    public static <Solution_> PillarSelectorFactory<Solution_> create(PillarSelectorConfig pillarSelectorConfig) {
        return new PillarSelectorFactory<Solution_>(pillarSelectorConfig);
    }

    public PillarSelectorFactory(PillarSelectorConfig pillarSelectorConfig) {
        super(pillarSelectorConfig);
    }

    public PillarSelector<Solution_> buildPillarSelector(HeuristicConfigPolicy<Solution_> configPolicy, SubPillarType subPillarType, Class<? extends Comparator> subPillarSequenceComparatorClass, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder, List<String> variableNameIncludeList) {
        if (subPillarType != SubPillarType.SEQUENCE && subPillarSequenceComparatorClass != null) {
            throw new IllegalArgumentException("Subpillar type (" + subPillarType + ") on pillarSelectorConfig (" + this.config + ") is not " + SubPillarType.SEQUENCE + ", yet subPillarSequenceComparatorClass (" + subPillarSequenceComparatorClass + ") is provided.");
        }
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) > 0) {
            throw new IllegalArgumentException("The pillarSelectorConfig (" + this.config + ")'s minimumCacheType (" + minimumCacheType + ") must not be higher than " + SelectionCacheType.STEP + " because the pillars change every step.");
        }
        boolean subPillarEnabled = subPillarType != SubPillarType.NONE;
        EntitySelectorConfig entitySelectorConfig_ = ((PillarSelectorConfig)this.config).getEntitySelectorConfig() == null ? new EntitySelectorConfig() : ((PillarSelectorConfig)this.config).getEntitySelectorConfig();
        EntitySelector entitySelector = EntitySelectorFactory.create(entitySelectorConfig_).buildEntitySelector(configPolicy, minimumCacheType, SelectionOrder.ORIGINAL);
        List variableDescriptors = this.deduceVariableDescriptorList(entitySelector.getEntityDescriptor(), variableNameIncludeList);
        if (!(subPillarEnabled || ((PillarSelectorConfig)this.config).getMinimumSubPillarSize() == null && ((PillarSelectorConfig)this.config).getMaximumSubPillarSize() == null)) {
            throw new IllegalArgumentException("The pillarSelectorConfig (" + this.config + ") must not disable subpillars while providing minimumSubPillarSize (" + ((PillarSelectorConfig)this.config).getMinimumSubPillarSize() + ") or maximumSubPillarSize (" + ((PillarSelectorConfig)this.config).getMaximumSubPillarSize() + ").");
        }
        SubPillarConfigPolicy subPillarPolicy = subPillarEnabled ? this.configureSubPillars(subPillarType, subPillarSequenceComparatorClass, entitySelector, ((PillarSelectorConfig)this.config).getMinimumSubPillarSize(), ((PillarSelectorConfig)this.config).getMaximumSubPillarSize()) : SubPillarConfigPolicy.withoutSubpillars();
        return new DefaultPillarSelector(entitySelector, variableDescriptors, inheritedSelectionOrder.toRandomSelectionBoolean(), subPillarPolicy);
    }

    private SubPillarConfigPolicy configureSubPillars(SubPillarType pillarType, Class<? extends Comparator> pillarOrderComparatorClass, EntitySelector<Solution_> entitySelector, Integer minimumSubPillarSize, Integer maximumSubPillarSize) {
        int actualMinimumSubPillarSize = Objects.requireNonNullElse(minimumSubPillarSize, 1);
        int actualMaximumSubPillarSize = Objects.requireNonNullElse(maximumSubPillarSize, Integer.MAX_VALUE);
        if (pillarType == null) {
            return SubPillarConfigPolicy.withSubpillars(actualMinimumSubPillarSize, actualMaximumSubPillarSize);
        }
        switch (pillarType) {
            case ALL: {
                return SubPillarConfigPolicy.withSubpillars(actualMinimumSubPillarSize, actualMaximumSubPillarSize);
            }
            case SEQUENCE: {
                if (pillarOrderComparatorClass == null) {
                    Class<?> entityClass = entitySelector.getEntityDescriptor().getEntityClass();
                    boolean isComparable = Comparable.class.isAssignableFrom(entityClass);
                    if (!isComparable) {
                        throw new IllegalArgumentException("Pillar type (" + pillarType + ") on pillarSelectorConfig (" + this.config + ") does not provide pillarOrderComparatorClass while the entity (" + entityClass.getCanonicalName() + ") does not implement Comparable.");
                    }
                    Comparator comparator = Comparable::compareTo;
                    return SubPillarConfigPolicy.sequential(actualMinimumSubPillarSize, actualMaximumSubPillarSize, comparator);
                }
                Comparator comparator = ConfigUtils.newInstance(this.config, "pillarOrderComparatorClass", pillarOrderComparatorClass);
                return SubPillarConfigPolicy.sequential(actualMinimumSubPillarSize, actualMaximumSubPillarSize, comparator);
            }
        }
        throw new IllegalStateException("Subpillars cannot be enabled and disabled at the same time.");
    }
}

