/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.solver;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverStatus;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.SolverManagerConfig;
import org.optaplanner.core.impl.solver.DefaultSolverManager;

public interface SolverManager<Solution_, ProblemId_>
extends AutoCloseable {
    public static <Solution_, ProblemId_> SolverManager<Solution_, ProblemId_> create(SolverConfig solverConfig) {
        return SolverManager.create(solverConfig, new SolverManagerConfig());
    }

    public static <Solution_, ProblemId_> SolverManager<Solution_, ProblemId_> create(SolverConfig solverConfig, SolverManagerConfig solverManagerConfig) {
        return SolverManager.create(SolverFactory.create(solverConfig), solverManagerConfig);
    }

    public static <Solution_, ProblemId_> SolverManager<Solution_, ProblemId_> create(SolverFactory<Solution_> solverFactory) {
        return SolverManager.create(solverFactory, new SolverManagerConfig());
    }

    public static <Solution_, ProblemId_> SolverManager<Solution_, ProblemId_> create(SolverFactory<Solution_> solverFactory, SolverManagerConfig solverManagerConfig) {
        return new DefaultSolverManager(solverFactory, solverManagerConfig);
    }

    default public SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Solution_ problem) {
        return this.solve(problemId, (Function<? super ProblemId_, ? extends Solution_>)((Function<Object, Object>)problemId_ -> problem), (Consumer<? super Solution_>)null, (BiConsumer<? super ProblemId_, ? super Throwable>)null);
    }

    default public SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Solution_ problem, Consumer<? super Solution_> finalBestSolutionConsumer) {
        return this.solve(problemId, (Function<? super ProblemId_, ? extends Solution_>)((Function<Object, Object>)problemId_ -> problem), finalBestSolutionConsumer, (BiConsumer<? super ProblemId_, ? super Throwable>)null);
    }

    default public SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Solution_ problem, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        return this.solve(problemId, problemId_ -> problem, finalBestSolutionConsumer, exceptionHandler);
    }

    default public SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> finalBestSolutionConsumer) {
        return this.solve(problemId, problemFinder, finalBestSolutionConsumer, (BiConsumer<? super ProblemId_, ? super Throwable>)null);
    }

    public SolverJob<Solution_, ProblemId_> solve(ProblemId_ var1, Function<? super ProblemId_, ? extends Solution_> var2, Consumer<? super Solution_> var3, BiConsumer<? super ProblemId_, ? super Throwable> var4);

    default public SolverJob<Solution_, ProblemId_> solveAndListen(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer) {
        return this.solveAndListen(problemId, problemFinder, bestSolutionConsumer, null, null);
    }

    default public SolverJob<Solution_, ProblemId_> solveAndListen(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        return this.solveAndListen(problemId, problemFinder, bestSolutionConsumer, null, exceptionHandler);
    }

    public SolverJob<Solution_, ProblemId_> solveAndListen(ProblemId_ var1, Function<? super ProblemId_, ? extends Solution_> var2, Consumer<? super Solution_> var3, Consumer<? super Solution_> var4, BiConsumer<? super ProblemId_, ? super Throwable> var5);

    public SolverStatus getSolverStatus(ProblemId_ var1);

    public void terminateEarly(ProblemId_ var1);

    @Override
    public void close();
}

