/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.stream.bi;

import java.math.BigDecimal;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.stream.bi.BiConstraintStreamHelper;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;

public interface BiConstraintStream<A, B>
extends ConstraintStream {
    public BiConstraintStream<A, B> filter(BiPredicate<A, B> var1);

    default public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream) {
        return this.join(otherStream, (TriJoiner<A, B, C>)new NoneTriJoiner());
    }

    public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> var1, TriJoiner<A, B, C> var2);

    default public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.join(otherStream, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.join(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.join(otherStream, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> ... joiners) {
        BiConstraintStreamHelper helper = new BiConstraintStreamHelper(this);
        return (TriConstraintStream)helper.join(otherStream, joiners);
    }

    default public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass) {
        return this.join(otherClass, (TriJoiner<A, B, C>)new NoneTriJoiner());
    }

    default public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.join(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.join(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.join(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> TriConstraintStream<A, B, C> join(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.join(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> TriConstraintStream<A, B, C> join(Class<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> BiConstraintStream<A, B> ifExists(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.ifExists(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> BiConstraintStream<A, B> ifExists(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifExists(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> BiConstraintStream<A, B> ifExists(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifExists(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> BiConstraintStream<A, B> ifExists(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifExists(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> BiConstraintStream<A, B> ifExists(Class<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.ifExistsIncludingNullVars(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifExistsIncludingNullVars(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifExistsIncludingNullVars(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifExistsIncludingNullVars(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> BiConstraintStream<A, B> ifExistsIncludingNullVars(Class<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> BiConstraintStream<A, B> ifNotExists(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.ifNotExists(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> BiConstraintStream<A, B> ifNotExists(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifNotExists(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> BiConstraintStream<A, B> ifNotExists(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifNotExists(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> BiConstraintStream<A, B> ifNotExists(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifNotExists(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> BiConstraintStream<A, B> ifNotExists(Class<C> var1, TriJoiner<A, B, C> ... var2);

    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner) {
        return this.ifNotExistsIncludingNullVars(otherClass, new TriJoiner[]{joiner});
    }

    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2) {
        return this.ifNotExistsIncludingNullVars(otherClass, new TriJoiner[]{joiner1, joiner2});
    }

    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3) {
        return this.ifNotExistsIncludingNullVars(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> otherClass, TriJoiner<A, B, C> joiner1, TriJoiner<A, B, C> joiner2, TriJoiner<A, B, C> joiner3, TriJoiner<A, B, C> joiner4) {
        return this.ifNotExistsIncludingNullVars(otherClass, new TriJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    public <C> BiConstraintStream<A, B> ifNotExistsIncludingNullVars(Class<C> var1, TriJoiner<A, B, C> ... var2);

    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(BiConstraintCollector<A, B, ResultContainer_, Result_> var1);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> BiConstraintStream<ResultA_, ResultB_> groupBy(BiConstraintCollector<A, B, ResultContainerA_, ResultA_> var1, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(BiConstraintCollector<A, B, ResultContainerA_, ResultA_> var1, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3);

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(BiConstraintCollector<A, B, ResultContainerA_, ResultA_> var1, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> var4);

    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(BiFunction<A, B, GroupKey_> var1);

    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(BiFunction<A, B, GroupKey_> var1, BiConstraintCollector<A, B, ResultContainer_, Result_> var2);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(BiFunction<A, B, GroupKey_> var1, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3);

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(BiFunction<A, B, GroupKey_> var1, BiConstraintCollector<A, B, ResultContainerB_, ResultB_> var2, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(BiFunction<A, B, GroupKeyA_> var1, BiFunction<A, B, GroupKeyB_> var2);

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(BiFunction<A, B, GroupKeyA_> var1, BiFunction<A, B, GroupKeyB_> var2, BiConstraintCollector<A, B, ResultContainer_, Result_> var3);

    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(BiFunction<A, B, GroupKeyA_> var1, BiFunction<A, B, GroupKeyB_> var2, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> var3, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(BiFunction<A, B, GroupKeyA_> var1, BiFunction<A, B, GroupKeyB_> var2, BiFunction<A, B, GroupKeyC_> var3);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(BiFunction<A, B, GroupKeyA_> var1, BiFunction<A, B, GroupKeyB_> var2, BiFunction<A, B, GroupKeyC_> var3, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> var4);

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(BiFunction<A, B, GroupKeyA_> var1, BiFunction<A, B, GroupKeyB_> var2, BiFunction<A, B, GroupKeyC_> var3, BiFunction<A, B, GroupKeyD_> var4);

    public <ResultA_> UniConstraintStream<ResultA_> map(BiFunction<A, B, ResultA_> var1);

    public <ResultB_> BiConstraintStream<A, ResultB_> flattenLast(Function<B, Iterable<ResultB_>> var1);

    public BiConstraintStream<A, B> distinct();

    default public Constraint penalize(String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.penalize(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint penalize(String var1, String var2, Score<?> var3, ToIntBiFunction<A, B> var4);

    default public Constraint penalizeLong(String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.penalizeLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint penalizeLong(String var1, String var2, Score<?> var3, ToLongBiFunction<A, B> var4);

    default public Constraint penalizeBigDecimal(String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.penalizeBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint penalizeBigDecimal(String var1, String var2, Score<?> var3, BiFunction<A, B, BigDecimal> var4);

    default public Constraint penalizeConfigurable(String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.penalizeConfigurable(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint penalizeConfigurable(String var1, String var2, ToIntBiFunction<A, B> var3);

    default public Constraint penalizeConfigurableLong(String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.penalizeConfigurableLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint penalizeConfigurableLong(String var1, String var2, ToLongBiFunction<A, B> var3);

    default public Constraint penalizeConfigurableBigDecimal(String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.penalizeConfigurableBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint penalizeConfigurableBigDecimal(String var1, String var2, BiFunction<A, B, BigDecimal> var3);

    default public Constraint reward(String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.reward(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint reward(String var1, String var2, Score<?> var3, ToIntBiFunction<A, B> var4);

    default public Constraint rewardLong(String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.rewardLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint rewardLong(String var1, String var2, Score<?> var3, ToLongBiFunction<A, B> var4);

    default public Constraint rewardBigDecimal(String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.rewardBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint rewardBigDecimal(String var1, String var2, Score<?> var3, BiFunction<A, B, BigDecimal> var4);

    default public Constraint rewardConfigurable(String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.rewardConfigurable(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint rewardConfigurable(String var1, String var2, ToIntBiFunction<A, B> var3);

    default public Constraint rewardConfigurableLong(String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.rewardConfigurableLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint rewardConfigurableLong(String var1, String var2, ToLongBiFunction<A, B> var3);

    default public Constraint rewardConfigurableBigDecimal(String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.rewardConfigurableBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint rewardConfigurableBigDecimal(String var1, String var2, BiFunction<A, B, BigDecimal> var3);

    default public Constraint impact(String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher) {
        return this.impact(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint impact(String var1, String var2, Score<?> var3, ToIntBiFunction<A, B> var4);

    default public Constraint impactLong(String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher) {
        return this.impactLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint impactLong(String var1, String var2, Score<?> var3, ToLongBiFunction<A, B> var4);

    default public Constraint impactBigDecimal(String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.impactBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, constraintWeight, matchWeigher);
    }

    public Constraint impactBigDecimal(String var1, String var2, Score<?> var3, BiFunction<A, B, BigDecimal> var4);

    default public Constraint impactConfigurable(String constraintName, ToIntBiFunction<A, B> matchWeigher) {
        return this.impactConfigurable(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint impactConfigurable(String var1, String var2, ToIntBiFunction<A, B> var3);

    default public Constraint impactConfigurableLong(String constraintName, ToLongBiFunction<A, B> matchWeigher) {
        return this.impactConfigurableLong(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint impactConfigurableLong(String var1, String var2, ToLongBiFunction<A, B> var3);

    default public Constraint impactConfigurableBigDecimal(String constraintName, BiFunction<A, B, BigDecimal> matchWeigher) {
        return this.impactConfigurableBigDecimal(this.getConstraintFactory().getDefaultConstraintPackage(), constraintName, matchWeigher);
    }

    public Constraint impactConfigurableBigDecimal(String var1, String var2, BiFunction<A, B, BigDecimal> var3);
}

