/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.ArrayList;
import java.util.Iterator;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class EntityDependentSortingValueSelector
extends AbstractValueSelector {
    protected final ValueSelector childValueSelector;
    protected final SelectionCacheType cacheType;
    protected final SelectionSorter sorter;
    protected ScoreDirector scoreDirector = null;

    public EntityDependentSortingValueSelector(ValueSelector childValueSelector, SelectionCacheType cacheType, SelectionSorter sorter) {
        this.childValueSelector = childValueSelector;
        this.cacheType = cacheType;
        this.sorter = sorter;
        if (childValueSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has a childValueSelector (" + childValueSelector + ") with neverEnding (" + childValueSelector.isNeverEnding() + ").");
        }
        if (cacheType != SelectionCacheType.STEP) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + (Object)((Object)cacheType) + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
    }

    public ValueSelector getChildValueSelector() {
        return this.childValueSelector;
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public void phaseStarted(AbstractPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public GenuineVariableDescriptor getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity);
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        long childSize = this.childValueSelector.getSize(entity);
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (" + this + ") has a childValueSelector (" + this.childValueSelector + ") with childSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        ArrayList cachedValueList = new ArrayList((int)childSize);
        this.childValueSelector.iterator(entity).forEachRemaining(cachedValueList::add);
        this.logger.trace("    Created cachedValueList: size ({}), valueSelector ({}).", (Object)cachedValueList.size(), (Object)this);
        this.sorter.sort(this.scoreDirector, cachedValueList);
        this.logger.trace("    Sorted cachedValueList: size ({}), valueSelector ({}).", (Object)cachedValueList.size(), (Object)this);
        return cachedValueList.iterator();
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.iterator(entity);
    }

    public String toString() {
        return "Sorting(" + this.childValueSelector + ")";
    }
}

