/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.ChildThreadType;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;

public class UnimprovedStepCountTermination
extends AbstractTermination {
    private final int unimprovedStepCountLimit;

    public UnimprovedStepCountTermination(int unimprovedStepCountLimit) {
        this.unimprovedStepCountLimit = unimprovedStepCountLimit;
        if (unimprovedStepCountLimit < 0) {
            throw new IllegalArgumentException("The unimprovedStepCountLimit (" + unimprovedStepCountLimit + ") cannot be negative.");
        }
    }

    public int getUnimprovedStepCountLimit() {
        return this.unimprovedStepCountLimit;
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used for phase termination.");
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope phaseScope) {
        int unimprovedStepCount = this.calculateUnimprovedStepCount(phaseScope);
        return unimprovedStepCount >= this.unimprovedStepCountLimit;
    }

    protected int calculateUnimprovedStepCount(AbstractPhaseScope phaseScope) {
        int bestStepIndex = phaseScope.getBestSolutionStepIndex();
        int lastStepIndex = phaseScope.getLastCompletedStepScope().getStepIndex();
        return lastStepIndex - bestStepIndex;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used for phase termination.");
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope phaseScope) {
        int unimprovedStepCount = this.calculateUnimprovedStepCount(phaseScope);
        double timeGradient = (double)unimprovedStepCount / (double)this.unimprovedStepCountLimit;
        return Math.min(timeGradient, 1.0);
    }

    @Override
    public UnimprovedStepCountTermination createChildThreadTermination(DefaultSolverScope solverScope, ChildThreadType childThreadType) {
        return new UnimprovedStepCountTermination(this.unimprovedStepCountLimit);
    }

    public String toString() {
        return "UnimprovedStepCount(" + this.unimprovedStepCountLimit + ")";
    }
}

