/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardmediumsoftbigdecimal;

import java.math.BigDecimal;
import org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore;
import org.optaplanner.core.impl.score.inliner.BigDecimalWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;

public class HardMediumSoftBigDecimalScoreInliner
extends ScoreInliner<HardMediumSoftBigDecimalScore> {
    protected BigDecimal hardScore = BigDecimal.ZERO;
    protected BigDecimal mediumScore = BigDecimal.ZERO;
    protected BigDecimal softScore = BigDecimal.ZERO;

    protected HardMediumSoftBigDecimalScoreInliner(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public BigDecimalWeightedScoreImpacter buildWeightedScoreImpacter(HardMediumSoftBigDecimalScore constraintWeight) {
        if (constraintWeight.equals(HardMediumSoftBigDecimalScore.ZERO)) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") cannot be zero, this constraint should have been culled during node creation.");
        }
        BigDecimal hardConstraintWeight = constraintWeight.getHardScore();
        BigDecimal mediumConstraintWeight = constraintWeight.getMediumScore();
        BigDecimal softConstraintWeight = constraintWeight.getSoftScore();
        if (mediumConstraintWeight.equals(BigDecimal.ZERO) && softConstraintWeight.equals(BigDecimal.ZERO)) {
            return (matchWeight, matchScoreConsumer) -> {
                BigDecimal hardImpact = hardConstraintWeight.multiply(matchWeight);
                this.hardScore = this.hardScore.add(hardImpact);
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardMediumSoftBigDecimalScore.ofHard(hardImpact));
                }
                return () -> {
                    this.hardScore = this.hardScore.subtract(hardImpact);
                };
            };
        }
        if (hardConstraintWeight.equals(BigDecimal.ZERO) && softConstraintWeight.equals(BigDecimal.ZERO)) {
            return (matchWeight, matchScoreConsumer) -> {
                BigDecimal mediumImpact = mediumConstraintWeight.multiply(matchWeight);
                this.mediumScore = this.mediumScore.add(mediumImpact);
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardMediumSoftBigDecimalScore.ofMedium(mediumImpact));
                }
                return () -> {
                    this.mediumScore = this.mediumScore.subtract(mediumImpact);
                };
            };
        }
        if (hardConstraintWeight.equals(BigDecimal.ZERO) && mediumConstraintWeight.equals(BigDecimal.ZERO)) {
            return (matchWeight, matchScoreConsumer) -> {
                BigDecimal softImpact = softConstraintWeight.multiply(matchWeight);
                this.softScore = this.softScore.add(softImpact);
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardMediumSoftBigDecimalScore.ofSoft(softImpact));
                }
                return () -> {
                    this.softScore = this.softScore.subtract(softImpact);
                };
            };
        }
        return (matchWeight, matchScoreConsumer) -> {
            BigDecimal hardImpact = hardConstraintWeight.multiply(matchWeight);
            BigDecimal mediumImpact = mediumConstraintWeight.multiply(matchWeight);
            BigDecimal softImpact = softConstraintWeight.multiply(matchWeight);
            this.hardScore = this.hardScore.add(hardImpact);
            this.mediumScore = this.mediumScore.add(mediumImpact);
            this.softScore = this.softScore.add(softImpact);
            if (this.constraintMatchEnabled) {
                matchScoreConsumer.accept(HardMediumSoftBigDecimalScore.of(hardImpact, mediumImpact, softImpact));
            }
            return () -> {
                this.hardScore = this.hardScore.subtract(hardImpact);
                this.mediumScore = this.mediumScore.subtract(mediumImpact);
                this.softScore = this.softScore.subtract(softImpact);
            };
        };
    }

    @Override
    public HardMediumSoftBigDecimalScore extractScore(int initScore) {
        return HardMediumSoftBigDecimalScore.ofUninitialized(initScore, this.hardScore, this.mediumScore, this.softScore);
    }

    public String toString() {
        return HardMediumSoftBigDecimalScore.class.getSimpleName() + " inliner";
    }
}

