/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.decorator;

import java.util.Iterator;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.decorator.AbstractCachingMoveSelector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class SortingMoveSelector
extends AbstractCachingMoveSelector {
    protected final SelectionSorter sorter;

    public SortingMoveSelector(MoveSelector childMoveSelector, SelectionCacheType cacheType, SelectionSorter sorter) {
        super(childMoveSelector, cacheType);
        this.sorter = sorter;
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        super.constructCache(solverScope);
        this.sorter.sort(solverScope.getScoreDirector(), this.cachedMoveList);
        this.logger.trace("    Sorted cachedMoveList: size ({}), moveSelector ({}).", (Object)this.cachedMoveList.size(), (Object)this);
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public Iterator<Move> iterator() {
        return this.cachedMoveList.iterator();
    }

    public String toString() {
        return "Sorting(" + this.childMoveSelector + ")";
    }
}

