/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.simplelong;

import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.impl.score.inliner.LongWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;

public class SimpleLongScoreInliner
extends ScoreInliner<SimpleLongScore> {
    protected long score;

    protected SimpleLongScoreInliner(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public LongWeightedScoreImpacter buildWeightedScoreImpacter(SimpleLongScore constraintWeight) {
        if (constraintWeight.equals(SimpleLongScore.ZERO)) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") cannot be zero, this constraint should have been culled during node creation.");
        }
        long simpleConstraintWeight = constraintWeight.getScore();
        return (matchWeight, matchScoreConsumer) -> {
            long impact = simpleConstraintWeight * matchWeight;
            this.score += impact;
            if (this.constraintMatchEnabled) {
                matchScoreConsumer.accept(SimpleLongScore.of(impact));
            }
            return () -> this.score -= impact;
        };
    }

    @Override
    public SimpleLongScore extractScore(int initScore) {
        return SimpleLongScore.ofUninitialized(initScore, this.score);
    }

    public String toString() {
        return SimpleLongScore.class.getSimpleName() + " inliner";
    }
}

