/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendable;

import java.util.Arrays;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.impl.score.inliner.IntWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;

public class BendableScoreInliner
extends ScoreInliner<BendableScore> {
    private int[] hardScores;
    private int[] softScores;

    public BendableScoreInliner(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new int[hardLevelsSize];
        this.softScores = new int[softLevelsSize];
    }

    public IntWeightedScoreImpacter buildWeightedScoreImpacter(BendableScore constraintWeight) {
        if (constraintWeight.equals(BendableScore.zero(this.hardScores.length, this.softScores.length))) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") cannot be zero, this constraint should have been culled during node creation.");
        }
        Integer singleLevel = null;
        for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
            if ((long)constraintWeight.getHardOrSoftScore(i) == 0L) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            int levelWeight = constraintWeight.getHardOrSoftScore(singleLevel);
            if (singleLevel < constraintWeight.getHardLevelsSize()) {
                int level = singleLevel;
                return (matchWeight, matchScoreConsumer) -> {
                    int hardImpact = levelWeight * matchWeight;
                    int n = level;
                    this.hardScores[n] = this.hardScores[n] + hardImpact;
                    if (this.constraintMatchEnabled) {
                        matchScoreConsumer.accept(BendableScore.ofHard(this.hardScores.length, this.softScores.length, level, hardImpact));
                    }
                    return () -> {
                        int n = level;
                        this.hardScores[n] = this.hardScores[n] - hardImpact;
                    };
                };
            }
            int level = singleLevel - constraintWeight.getHardLevelsSize();
            return (matchWeight, matchScoreConsumer) -> {
                int softImpact = levelWeight * matchWeight;
                int n = level;
                this.softScores[n] = this.softScores[n] + softImpact;
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(BendableScore.ofSoft(this.hardScores.length, this.softScores.length, level, softImpact));
                }
                return () -> {
                    int n = level;
                    this.softScores[n] = this.softScores[n] - softImpact;
                };
            };
        }
        return (matchWeight, matchScoreConsumer) -> {
            int i;
            int[] hardImpacts = new int[this.hardScores.length];
            int[] softImpacts = new int[this.softScores.length];
            for (i = 0; i < hardImpacts.length; ++i) {
                hardImpacts[i] = constraintWeight.getHardScore(i) * matchWeight;
                int n = i;
                this.hardScores[n] = this.hardScores[n] + hardImpacts[i];
            }
            for (i = 0; i < softImpacts.length; ++i) {
                softImpacts[i] = constraintWeight.getSoftScore(i) * matchWeight;
                int n = i;
                this.softScores[n] = this.softScores[n] + softImpacts[i];
            }
            if (this.constraintMatchEnabled) {
                matchScoreConsumer.accept(BendableScore.of(hardImpacts, softImpacts));
            }
            return () -> {
                int i;
                for (i = 0; i < hardImpacts.length; ++i) {
                    int n = i;
                    this.hardScores[n] = this.hardScores[n] - hardImpacts[i];
                }
                for (i = 0; i < softImpacts.length; ++i) {
                    int n = i;
                    this.softScores[n] = this.softScores[n] - softImpacts[i];
                }
            };
        };
    }

    @Override
    public BendableScore extractScore(int initScore) {
        return BendableScore.ofUninitialized(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableScore.class.getSimpleName() + " inliner";
    }
}

