/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class KOptMove<Solution_>
extends AbstractMove<Solution_> {
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final SingletonInverseVariableSupply inverseVariableSupply;
    protected final AnchorVariableSupply anchorVariableSupply;
    protected final Object entity;
    protected final Object[] values;

    public KOptMove(GenuineVariableDescriptor<Solution_> variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, AnchorVariableSupply anchorVariableSupply, Object entity, Object[] values) {
        this.variableDescriptor = variableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.anchorVariableSupply = anchorVariableSupply;
        this.entity = entity;
        this.values = values;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public Object getEntity() {
        return this.entity;
    }

    public Object[] getValues() {
        return this.values;
    }

    public int getK() {
        return 1 + this.values.length;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        Object firstAnchor = this.anchorVariableSupply.getAnchor(this.entity);
        Object firstValue = this.variableDescriptor.getValue(this.entity);
        Object formerAnchor = firstAnchor;
        Object formerValue = firstValue;
        for (Object value : this.values) {
            Object anchor;
            Object object = anchor = this.variableDescriptor.isValuePotentialAnchor(value) ? value : this.anchorVariableSupply.getAnchor(value);
            if (anchor == formerAnchor && this.compareValuesInSameChain(formerValue, value) >= 0) {
                return false;
            }
            formerAnchor = anchor;
            formerValue = value;
        }
        return firstAnchor != formerAnchor || this.compareValuesInSameChain(formerValue, firstValue) < 0;
    }

    protected int compareValuesInSameChain(Object a, Object b) {
        if (a == b) {
            return 0;
        }
        Object afterA = this.inverseVariableSupply.getInverseSingleton(a);
        while (afterA != null) {
            if (afterA == b) {
                return 1;
            }
            afterA = this.inverseVariableSupply.getInverseSingleton(afterA);
        }
        return -1;
    }

    @Override
    public KOptMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        Object[] undoValues = new Object[this.values.length];
        undoValues[0] = this.variableDescriptor.getValue(this.entity);
        for (int i = 1; i < this.values.length; ++i) {
            undoValues[i] = this.values[this.values.length - i];
        }
        return new KOptMove<Solution_>(this.variableDescriptor, this.inverseVariableSupply, this.anchorVariableSupply, this.entity, undoValues);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        Object firstValue = this.variableDescriptor.getValue(this.entity);
        Object formerEntity = this.entity;
        for (int i = 0; i < this.values.length; ++i) {
            Object value = this.values[i];
            if (formerEntity != null) {
                scoreDirector.changeVariableFacade(this.variableDescriptor, formerEntity, value);
            }
            formerEntity = this.inverseVariableSupply.getInverseSingleton(value);
        }
        if (formerEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, formerEntity, firstValue);
        }
    }

    @Override
    public KOptMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        throw new UnsupportedOperationException("https://issues.jboss.org/browse/PLANNER-1250");
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        ArrayList<Object> allEntityList = new ArrayList<Object>(this.values.length + 1);
        allEntityList.add(this.entity);
        for (int i = 0; i < this.values.length; ++i) {
            Object value = this.values[i];
            allEntityList.add(this.inverseVariableSupply.getInverseSingleton(value));
        }
        return allEntityList;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> allValueList = new ArrayList<Object>(this.values.length + 1);
        allValueList.add(this.variableDescriptor.getValue(this.entity));
        Collections.addAll(allValueList, this.values);
        return allValueList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof KOptMove) {
            KOptMove other = (KOptMove)o;
            return new EqualsBuilder().append(this.entity, other.entity).append(this.values, other.values).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.entity).append(this.values).toHashCode();
    }

    public String toString() {
        Object leftValue = this.variableDescriptor.getValue(this.entity);
        StringBuilder builder = new StringBuilder(80 * this.values.length);
        builder.append(this.entity).append(" {").append(leftValue);
        for (int i = 0; i < this.values.length; ++i) {
            Object value = this.values[i];
            Object oldEntity = this.inverseVariableSupply.getInverseSingleton(value);
            builder.append("} -kOpt-> ").append(oldEntity).append(" {").append(value);
        }
        builder.append("}");
        return builder.toString();
    }
}

