/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.iterator;

import java.util.Collections;
import java.util.Iterator;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;

public abstract class AbstractOriginalChangeIterator<S extends Move>
extends UpcomingSelectionIterator<S> {
    private final EntitySelector entitySelector;
    private final ValueSelector valueSelector;
    private Iterator<Object> entityIterator;
    private Iterator<Object> valueIterator;
    private Object upcomingEntity;

    public AbstractOriginalChangeIterator(EntitySelector entitySelector, ValueSelector valueSelector) {
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.entityIterator = entitySelector.iterator();
        this.valueIterator = Collections.emptyIterator();
    }

    @Override
    protected S createUpcomingSelection() {
        while (!this.valueIterator.hasNext()) {
            if (!this.entityIterator.hasNext()) {
                return (S)((Move)this.noUpcomingSelection());
            }
            this.upcomingEntity = this.entityIterator.next();
            this.valueIterator = this.valueSelector.iterator(this.upcomingEntity);
        }
        Object toValue = this.valueIterator.next();
        return this.newChangeSelection(this.upcomingEntity, toValue);
    }

    protected abstract S newChangeSelection(Object var1, Object var2);
}

