/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.value.chained;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.SelectorConfig;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.DefaultSubChainSelector;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChainSelector;

@XStreamAlias(value="subChainSelector")
public class SubChainSelectorConfig
extends SelectorConfig<SubChainSelectorConfig> {
    private static final int DEFAULT_MINIMUM_SUB_CHAIN_SIZE = 1;
    private static final int DEFAULT_MAXIMUM_SUB_CHAIN_SIZE = Integer.MAX_VALUE;
    @XStreamAlias(value="valueSelector")
    protected ValueSelectorConfig valueSelectorConfig = null;
    protected Integer minimumSubChainSize = null;
    protected Integer maximumSubChainSize = null;

    public ValueSelectorConfig getValueSelectorConfig() {
        return this.valueSelectorConfig;
    }

    public void setValueSelectorConfig(ValueSelectorConfig valueSelectorConfig) {
        this.valueSelectorConfig = valueSelectorConfig;
    }

    public Integer getMinimumSubChainSize() {
        return this.minimumSubChainSize;
    }

    public void setMinimumSubChainSize(Integer minimumSubChainSize) {
        this.minimumSubChainSize = minimumSubChainSize;
    }

    public Integer getMaximumSubChainSize() {
        return this.maximumSubChainSize;
    }

    public void setMaximumSubChainSize(Integer maximumSubChainSize) {
        this.maximumSubChainSize = maximumSubChainSize;
    }

    public SubChainSelector buildSubChainSelector(HeuristicConfigPolicy configPolicy, EntityDescriptor entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) > 0) {
            throw new IllegalArgumentException("The subChainSelectorConfig (" + this + ")'s minimumCacheType (" + (Object)((Object)minimumCacheType) + ") must not be higher than " + (Object)((Object)SelectionCacheType.STEP) + " because the chains change every step.");
        }
        ValueSelectorConfig valueSelectorConfig_ = this.valueSelectorConfig == null ? new ValueSelectorConfig() : this.valueSelectorConfig;
        ValueSelector valueSelector = valueSelectorConfig_.buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, SelectionOrder.ORIGINAL);
        if (!(valueSelector instanceof EntityIndependentValueSelector)) {
            throw new IllegalArgumentException("The minimumCacheType (" + this + ") needs to be based on an EntityIndependentValueSelector (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
        }
        return new DefaultSubChainSelector((EntityIndependentValueSelector)valueSelector, inheritedSelectionOrder.toRandomSelectionBoolean(), (Integer)ObjectUtils.defaultIfNull((Object)this.minimumSubChainSize, (Object)1), (Integer)ObjectUtils.defaultIfNull((Object)this.maximumSubChainSize, (Object)Integer.MAX_VALUE));
    }

    @Override
    public void inherit(SubChainSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.valueSelectorConfig = ConfigUtils.inheritConfig(this.valueSelectorConfig, inheritedConfig.getValueSelectorConfig());
        this.minimumSubChainSize = ConfigUtils.inheritOverwritableProperty(this.minimumSubChainSize, inheritedConfig.getMinimumSubChainSize());
        this.maximumSubChainSize = ConfigUtils.inheritOverwritableProperty(this.maximumSubChainSize, inheritedConfig.getMaximumSubChainSize());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.valueSelectorConfig + ")";
    }
}

