/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftlong;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardSoftLongScoreHolder
extends AbstractScoreHolder<HardSoftLongScore> {
    protected final Map<Rule, BiConsumer<RuleContext, Long>> matchExecutorByNumberMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, Long>>();
    protected final Map<Rule, BiConsumer<RuleContext, HardSoftLongScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, HardSoftLongScore>>();
    protected long hardScore;
    protected long softScore;

    public HardSoftLongScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardSoftLongScore.ZERO);
    }

    public long getHardScore() {
        return this.hardScore;
    }

    public long getSoftScore() {
        return this.softScore;
    }

    @Override
    public void configureConstraintWeight(Rule rule, HardSoftLongScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        BiConsumer<RuleContext, Long> matchExecutor = constraintWeight.equals(HardSoftLongScore.ZERO) ? (kcontext, matchWeight) -> {} : (constraintWeight.getSoftScore() == 0L ? (kcontext, matchWeight) -> this.addHardConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore() * matchWeight) : (constraintWeight.getHardScore() == 0L ? (kcontext, matchWeight) -> this.addSoftConstraintMatch((RuleContext)kcontext, constraintWeight.getSoftScore() * matchWeight) : (kcontext, matchWeight) -> this.addMultiConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore() * matchWeight, constraintWeight.getSoftScore() * matchWeight)));
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> this.addMultiConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore() * weightMultiplier.getHardScore(), constraintWeight.getSoftScore() * weightMultiplier.getSoftScore()));
    }

    public void penalize(RuleContext kcontext) {
        this.reward(kcontext, -1L);
    }

    public void penalize(RuleContext kcontext, long weightMultiplier) {
        this.reward(kcontext, -weightMultiplier);
    }

    public void penalize(RuleContext kcontext, long hardWeightMultiplier, long softWeightMultiplier) {
        this.reward(kcontext, -hardWeightMultiplier, -softWeightMultiplier);
    }

    public void reward(RuleContext kcontext) {
        this.reward(kcontext, 1L);
    }

    public void reward(RuleContext kcontext, long weightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, Long> matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    public void reward(RuleContext kcontext, long hardWeightMultiplier, long softWeightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, HardSoftLongScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, HardSoftLongScore.of(hardWeightMultiplier, softWeightMultiplier));
    }

    public void addHardConstraintMatch(RuleContext kcontext, long hardWeight) {
        this.hardScore += hardWeight;
        this.registerConstraintMatch(kcontext, () -> this.hardScore -= hardWeight, () -> HardSoftLongScore.of(hardWeight, 0L));
    }

    public void addSoftConstraintMatch(RuleContext kcontext, long softWeight) {
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> this.softScore -= softWeight, () -> HardSoftLongScore.of(0L, softWeight));
    }

    public void addMultiConstraintMatch(RuleContext kcontext, long hardWeight, long softWeight) {
        this.hardScore += hardWeight;
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore -= hardWeight;
            this.softScore -= softWeight;
        }, () -> HardSoftLongScore.of(hardWeight, softWeight));
    }

    @Override
    public HardSoftLongScore extractScore(int initScore) {
        return HardSoftLongScore.ofUninitialized(initScore, this.hardScore, this.softScore);
    }
}

