/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class MovableChainedTrailingValueFilter
implements SelectionFilter<Object> {
    private final GenuineVariableDescriptor variableDescriptor;

    public MovableChainedTrailingValueFilter(GenuineVariableDescriptor variableDescriptor) {
        this.variableDescriptor = variableDescriptor;
    }

    @Override
    public boolean accept(ScoreDirector scoreDirector, Object value) {
        if (value == null) {
            return true;
        }
        SingletonInverseVariableSupply supply = this.retrieveSingletonInverseVariableSupply(scoreDirector);
        Object trailingEntity = supply.getInverseSingleton(value);
        EntityDescriptor entityDescriptor = this.variableDescriptor.getEntityDescriptor();
        if (trailingEntity == null || !entityDescriptor.matchesEntity(trailingEntity)) {
            return true;
        }
        return entityDescriptor.getMovableEntitySelectionFilter().accept(scoreDirector, trailingEntity);
    }

    protected SingletonInverseVariableSupply retrieveSingletonInverseVariableSupply(ScoreDirector scoreDirector) {
        SupplyManager supplyManager = ((InnerScoreDirector)scoreDirector).getSupplyManager();
        return supplyManager.demand(new SingletonInverseVariableDemand(this.variableDescriptor));
    }
}

