/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SwapMove
extends AbstractMove {
    protected final List<GenuineVariableDescriptor> variableDescriptorList;
    protected final Object leftEntity;
    protected final Object rightEntity;

    public SwapMove(List<GenuineVariableDescriptor> variableDescriptorList, Object leftEntity, Object rightEntity) {
        this.variableDescriptorList = variableDescriptorList;
        this.leftEntity = leftEntity;
        this.rightEntity = rightEntity;
    }

    public Object getLeftEntity() {
        return this.leftEntity;
    }

    public Object getRightEntity() {
        return this.rightEntity;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        boolean movable = false;
        for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptorList) {
            Solution workingSolution;
            Object rightValue;
            Object leftValue = variableDescriptor.getValue(this.leftEntity);
            if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = variableDescriptor.getValue(this.rightEntity)))) continue;
            movable = true;
            if (variableDescriptor.isValueRangeEntityIndependent()) continue;
            ValueRangeDescriptor valueRangeDescriptor = variableDescriptor.getValueRangeDescriptor();
            ValueRange<?> rightValueRange = valueRangeDescriptor.extractValueRange(workingSolution = scoreDirector.getWorkingSolution(), this.rightEntity);
            if (!rightValueRange.contains(leftValue)) {
                return false;
            }
            ValueRange<?> leftValueRange = valueRangeDescriptor.extractValueRange(workingSolution, this.leftEntity);
            if (leftValueRange.contains(rightValue)) continue;
            return false;
        }
        return movable;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new SwapMove(this.variableDescriptorList, this.rightEntity, this.leftEntity);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector scoreDirector) {
        for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptorList) {
            Object oldRightValue;
            Object oldLeftValue = variableDescriptor.getValue(this.leftEntity);
            if (ObjectUtils.equals((Object)oldLeftValue, (Object)(oldRightValue = variableDescriptor.getValue(this.rightEntity)))) continue;
            scoreDirector.beforeVariableChanged(variableDescriptor, this.leftEntity);
            variableDescriptor.setValue(this.leftEntity, oldRightValue);
            scoreDirector.afterVariableChanged(variableDescriptor, this.leftEntity);
            scoreDirector.beforeVariableChanged(variableDescriptor, this.rightEntity);
            variableDescriptor.setValue(this.rightEntity, oldLeftValue);
            scoreDirector.afterVariableChanged(variableDescriptor, this.rightEntity);
        }
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        StringBuilder moveTypeDescription = new StringBuilder(20 * (this.variableDescriptorList.size() + 1));
        moveTypeDescription.append(this.getClass().getSimpleName()).append("(");
        String delimiter = "";
        for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptorList) {
            moveTypeDescription.append(delimiter).append(variableDescriptor.getSimpleEntityAndVariableName());
            delimiter = ", ";
        }
        moveTypeDescription.append(")");
        return moveTypeDescription.toString();
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftEntity, this.rightEntity);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(this.variableDescriptorList.size() * 2);
        for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptorList) {
            values.add(variableDescriptor.getValue(this.leftEntity));
            values.add(variableDescriptor.getValue(this.rightEntity));
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SwapMove) {
            SwapMove other = (SwapMove)o;
            return new EqualsBuilder().append(this.leftEntity, other.leftEntity).append(this.rightEntity, other.rightEntity).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.leftEntity).append(this.rightEntity).toHashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.variableDescriptorList.size() * 16);
        s.append(this.leftEntity).append(" {");
        this.appendVariablesToString(s, this.leftEntity);
        s.append("} <-> ");
        s.append(this.rightEntity).append(" {");
        this.appendVariablesToString(s, this.rightEntity);
        s.append("}");
        return s.toString();
    }

    protected void appendVariablesToString(StringBuilder s, Object entity) {
        boolean first = true;
        for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptorList) {
            if (!first) {
                s.append(", ");
            }
            s.append(variableDescriptor.getValue(entity));
            first = false;
        }
    }
}

