/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.entity.pillar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.SelectorConfig;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.DefaultPillarSelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.PillarSelector;

@XStreamAlias(value="pillarSelector")
public class PillarSelectorConfig
extends SelectorConfig<PillarSelectorConfig> {
    @XStreamAlias(value="entitySelector")
    protected EntitySelectorConfig entitySelectorConfig = null;
    protected Boolean subPillarEnabled = null;
    protected Integer minimumSubPillarSize = null;
    protected Integer maximumSubPillarSize = null;

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public Boolean getSubPillarEnabled() {
        return this.subPillarEnabled;
    }

    public void setSubPillarEnabled(Boolean subPillarEnabled) {
        this.subPillarEnabled = subPillarEnabled;
    }

    public Integer getMinimumSubPillarSize() {
        return this.minimumSubPillarSize;
    }

    public void setMinimumSubPillarSize(Integer minimumSubPillarSize) {
        this.minimumSubPillarSize = minimumSubPillarSize;
    }

    public Integer getMaximumSubPillarSize() {
        return this.maximumSubPillarSize;
    }

    public void setMaximumSubPillarSize(Integer maximumSubPillarSize) {
        this.maximumSubPillarSize = maximumSubPillarSize;
    }

    public PillarSelector buildPillarSelector(HeuristicConfigPolicy configPolicy, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder, List<String> variableNameIncludeList) {
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) > 0) {
            throw new IllegalArgumentException("The pillarSelectorConfig (" + this + ")'s minimumCacheType (" + (Object)((Object)minimumCacheType) + ") must not be higher than " + (Object)((Object)SelectionCacheType.STEP) + " because the pillars change every step.");
        }
        EntitySelectorConfig entitySelectorConfig_ = this.entitySelectorConfig == null ? new EntitySelectorConfig() : this.entitySelectorConfig;
        EntitySelector entitySelector = entitySelectorConfig_.buildEntitySelector(configPolicy, minimumCacheType, SelectionOrder.ORIGINAL);
        List<GenuineVariableDescriptor> variableDescriptors = this.deduceVariableDescriptorList(entitySelector.getEntityDescriptor(), variableNameIncludeList);
        if (BooleanUtils.isFalse((Boolean)this.subPillarEnabled) && (this.minimumSubPillarSize != null || this.maximumSubPillarSize != null)) {
            throw new IllegalArgumentException("The pillarSelectorConfig (" + this + ") must not have subPillarEnabled (" + this.subPillarEnabled + ") with minimumSubPillarSize (" + this.minimumSubPillarSize + ") and maximumSubPillarSize (" + this.maximumSubPillarSize + ").");
        }
        return new DefaultPillarSelector(entitySelector, variableDescriptors, inheritedSelectionOrder.toRandomSelectionBoolean(), (Boolean)ObjectUtils.defaultIfNull((Object)this.subPillarEnabled, (Object)true), (Integer)ObjectUtils.defaultIfNull((Object)this.minimumSubPillarSize, (Object)1), (Integer)ObjectUtils.defaultIfNull((Object)this.maximumSubPillarSize, (Object)Integer.MAX_VALUE));
    }

    @Override
    public void inherit(PillarSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.entitySelectorConfig = ConfigUtils.inheritConfig(this.entitySelectorConfig, inheritedConfig.getEntitySelectorConfig());
        this.subPillarEnabled = ConfigUtils.inheritOverwritableProperty(this.subPillarEnabled, inheritedConfig.getSubPillarEnabled());
        this.minimumSubPillarSize = ConfigUtils.inheritOverwritableProperty(this.minimumSubPillarSize, inheritedConfig.getMinimumSubPillarSize());
        this.maximumSubPillarSize = ConfigUtils.inheritOverwritableProperty(this.maximumSubPillarSize, inheritedConfig.getMaximumSubPillarSize());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + ")";
    }
}

