/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftlong;

import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.FeasibilityScore;

public final class HardSoftLongScore
extends AbstractScore<HardSoftLongScore>
implements FeasibilityScore<HardSoftLongScore> {
    private static final String HARD_LABEL = "hard";
    private static final String SOFT_LABEL = "soft";
    private final long hardScore;
    private final long softScore;

    public static HardSoftLongScore parseScore(String scoreString) {
        String[] levelStrings = HardSoftLongScore.parseLevelStrings(HardSoftLongScore.class, scoreString, HARD_LABEL, SOFT_LABEL);
        long hardScore = HardSoftLongScore.parseLevelAsLong(HardSoftLongScore.class, scoreString, levelStrings[0]);
        long softScore = HardSoftLongScore.parseLevelAsLong(HardSoftLongScore.class, scoreString, levelStrings[1]);
        return HardSoftLongScore.valueOf(hardScore, softScore);
    }

    public static HardSoftLongScore valueOf(long hardScore, long softScore) {
        return new HardSoftLongScore(hardScore, softScore);
    }

    private HardSoftLongScore() {
        this.hardScore = Long.MIN_VALUE;
        this.softScore = Long.MIN_VALUE;
    }

    private HardSoftLongScore(long hardScore, long softScore) {
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    public long getHardScore() {
        return this.hardScore;
    }

    public long getSoftScore() {
        return this.softScore;
    }

    @Override
    public boolean isFeasible() {
        return this.getHardScore() >= 0L;
    }

    @Override
    public HardSoftLongScore add(HardSoftLongScore augment) {
        return new HardSoftLongScore(this.hardScore + augment.getHardScore(), this.softScore + augment.getSoftScore());
    }

    @Override
    public HardSoftLongScore subtract(HardSoftLongScore subtrahend) {
        return new HardSoftLongScore(this.hardScore - subtrahend.getHardScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardSoftLongScore multiply(double multiplicand) {
        return new HardSoftLongScore((long)Math.floor((double)this.hardScore * multiplicand), (long)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardSoftLongScore divide(double divisor) {
        return new HardSoftLongScore((long)Math.floor((double)this.hardScore / divisor), (long)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public HardSoftLongScore power(double exponent) {
        return new HardSoftLongScore((long)Math.floor(Math.pow(this.hardScore, exponent)), (long)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public HardSoftLongScore negate() {
        return new HardSoftLongScore(-this.hardScore, -this.softScore);
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardSoftLongScore) {
            HardSoftLongScore other = (HardSoftLongScore)o;
            return this.hardScore == other.getHardScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return (629 + Long.valueOf(this.hardScore).hashCode()) * 37 + Long.valueOf(this.softScore).hashCode();
    }

    @Override
    public int compareTo(HardSoftLongScore other) {
        if (this.hardScore != other.getHardScore()) {
            if (this.hardScore < other.getHardScore()) {
                return -1;
            }
            return 1;
        }
        if (this.softScore < other.getSoftScore()) {
            return -1;
        }
        if (this.softScore > other.getSoftScore()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.hardScore + HARD_LABEL + "/" + this.softScore + SOFT_LABEL;
    }
}

