/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardsoftdouble;

import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.FeasibilityScore;

public final class HardSoftDoubleScore
extends AbstractScore<HardSoftDoubleScore>
implements FeasibilityScore<HardSoftDoubleScore> {
    private static final String HARD_LABEL = "hard";
    private static final String SOFT_LABEL = "soft";
    private final double hardScore;
    private final double softScore;

    public static HardSoftDoubleScore parseScore(String scoreString) {
        String[] levelStrings = HardSoftDoubleScore.parseLevelStrings(HardSoftDoubleScore.class, scoreString, HARD_LABEL, SOFT_LABEL);
        double hardScore = HardSoftDoubleScore.parseLevelAsDouble(HardSoftDoubleScore.class, scoreString, levelStrings[0]);
        double softScore = HardSoftDoubleScore.parseLevelAsDouble(HardSoftDoubleScore.class, scoreString, levelStrings[1]);
        return HardSoftDoubleScore.valueOf(hardScore, softScore);
    }

    public static HardSoftDoubleScore valueOf(double hardScore, double softScore) {
        return new HardSoftDoubleScore(hardScore, softScore);
    }

    private HardSoftDoubleScore() {
        this.hardScore = Double.NaN;
        this.softScore = Double.NaN;
    }

    private HardSoftDoubleScore(double hardScore, double softScore) {
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    public double getHardScore() {
        return this.hardScore;
    }

    public double getSoftScore() {
        return this.softScore;
    }

    @Override
    public boolean isFeasible() {
        return this.getHardScore() >= 0.0;
    }

    @Override
    public HardSoftDoubleScore add(HardSoftDoubleScore augment) {
        return new HardSoftDoubleScore(this.hardScore + augment.getHardScore(), this.softScore + augment.getSoftScore());
    }

    @Override
    public HardSoftDoubleScore subtract(HardSoftDoubleScore subtrahend) {
        return new HardSoftDoubleScore(this.hardScore - subtrahend.getHardScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardSoftDoubleScore multiply(double multiplicand) {
        return new HardSoftDoubleScore(this.hardScore * multiplicand, this.softScore * multiplicand);
    }

    @Override
    public HardSoftDoubleScore divide(double divisor) {
        return new HardSoftDoubleScore(this.hardScore / divisor, this.softScore / divisor);
    }

    @Override
    public HardSoftDoubleScore power(double exponent) {
        return new HardSoftDoubleScore(Math.pow(this.hardScore, exponent), Math.pow(this.softScore, exponent));
    }

    @Override
    public HardSoftDoubleScore negate() {
        return new HardSoftDoubleScore(-this.hardScore, -this.softScore);
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardSoftDoubleScore) {
            HardSoftDoubleScore other = (HardSoftDoubleScore)o;
            return this.hardScore == other.getHardScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return (629 + Double.valueOf(this.hardScore).hashCode()) * 37 + Double.valueOf(this.softScore).hashCode();
    }

    @Override
    public int compareTo(HardSoftDoubleScore other) {
        if (this.hardScore != other.getHardScore()) {
            if (this.hardScore < other.getHardScore()) {
                return -1;
            }
            return 1;
        }
        if (this.softScore < other.getSoftScore()) {
            return -1;
        }
        if (this.softScore > other.getSoftScore()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.hardScore + HARD_LABEL + "/" + this.softScore + SOFT_LABEL;
    }
}

