/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;

public class UnimprovedTimeMillisSpentTermination
extends AbstractTermination {
    private final long unimprovedTimeMillisSpentLimit;

    public UnimprovedTimeMillisSpentTermination(long unimprovedTimeMillisSpentLimit) {
        this.unimprovedTimeMillisSpentLimit = unimprovedTimeMillisSpentLimit;
        if (unimprovedTimeMillisSpentLimit <= 0L) {
            throw new IllegalArgumentException("The unimprovedTimeMillisSpentLimit (" + unimprovedTimeMillisSpentLimit + ") cannot be negative.");
        }
    }

    public long getUnimprovedTimeMillisSpentLimit() {
        return this.unimprovedTimeMillisSpentLimit;
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        long bestSolutionTimeMillis = solverScope.getBestSolutionTimeMillis();
        return this.isTerminated(bestSolutionTimeMillis);
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope phaseScope) {
        long bestSolutionTimeMillis = phaseScope.getPhaseBestSolutionTimeMillis();
        return this.isTerminated(bestSolutionTimeMillis);
    }

    protected boolean isTerminated(long bestSolutionTimeMillis) {
        long now = System.currentTimeMillis();
        long unimprovedTimeMillisSpent = now - bestSolutionTimeMillis;
        return unimprovedTimeMillisSpent >= this.unimprovedTimeMillisSpentLimit;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        long bestSolutionTimeMillis = solverScope.getBestSolutionTimeMillis();
        return this.calculateTimeGradient(bestSolutionTimeMillis);
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope phaseScope) {
        long bestSolutionTimeMillis = phaseScope.getPhaseBestSolutionTimeMillis();
        return this.calculateTimeGradient(bestSolutionTimeMillis);
    }

    protected double calculateTimeGradient(long bestSolutionTimeMillis) {
        long now = System.currentTimeMillis();
        long unimprovedTimeMillisSpent = now - bestSolutionTimeMillis;
        double timeGradient = (double)unimprovedTimeMillisSpent / (double)this.unimprovedTimeMillisSpentLimit;
        return Math.min(timeGradient, 1.0);
    }
}

