/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.domain;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import org.reflections.Reflections;

public abstract class ReflectionsWorkaroundClasspathHelper {
    public static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader staticClassLoader() {
        return Reflections.class.getClassLoader();
    }

    public static ClassLoader[] classLoaders(ClassLoader ... classLoaders) {
        ClassLoader[] classLoaderArray;
        if (classLoaders != null && classLoaders.length != 0) {
            return classLoaders;
        }
        ClassLoader contextClassLoader = ReflectionsWorkaroundClasspathHelper.contextClassLoader();
        ClassLoader staticClassLoader = ReflectionsWorkaroundClasspathHelper.staticClassLoader();
        if (contextClassLoader != null) {
            if (staticClassLoader != null && contextClassLoader != staticClassLoader) {
                ClassLoader[] classLoaderArray2 = new ClassLoader[2];
                classLoaderArray2[0] = contextClassLoader;
                classLoaderArray = classLoaderArray2;
                classLoaderArray2[1] = staticClassLoader;
            } else {
                ClassLoader[] classLoaderArray3 = new ClassLoader[1];
                classLoaderArray = classLoaderArray3;
                classLoaderArray3[0] = contextClassLoader;
            }
        } else {
            classLoaderArray = new ClassLoader[]{};
        }
        return classLoaderArray;
    }

    public static Collection<URL> forPackage(String name, ClassLoader ... classLoaders) {
        return ReflectionsWorkaroundClasspathHelper.forResource(ReflectionsWorkaroundClasspathHelper.resourceName(name), classLoaders);
    }

    public static Collection<URL> forResource(String resourceName, ClassLoader ... classLoaders) {
        ClassLoader[] loaders;
        ArrayList<URL> result = new ArrayList<URL>();
        for (ClassLoader classLoader : loaders = ReflectionsWorkaroundClasspathHelper.classLoaders(classLoaders)) {
            try {
                Enumeration<URL> urls = classLoader.getResources(resourceName);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    int index = url.toExternalForm().lastIndexOf(resourceName);
                    if (index != -1) {
                        String newUrlString = url.toExternalForm().substring(0, index);
                        result.add(new URL(url, newUrlString));
                        continue;
                    }
                    result.add(url);
                }
            }
            catch (IOException e) {
                if (Reflections.log == null) continue;
                Reflections.log.error("error getting resources for " + resourceName, (Throwable)e);
            }
        }
        return ReflectionsWorkaroundClasspathHelper.distinctUrls(result);
    }

    public static URL forClass(Class<?> aClass, ClassLoader ... classLoaders) {
        ClassLoader[] loaders = ReflectionsWorkaroundClasspathHelper.classLoaders(classLoaders);
        String resourceName = aClass.getName().replace(".", "/") + ".class";
        for (ClassLoader classLoader : loaders) {
            try {
                URL url = classLoader.getResource(resourceName);
                if (url == null) continue;
                String normalizedUrl = url.toExternalForm().substring(0, url.toExternalForm().lastIndexOf(aClass.getPackage().getName().replace(".", "/")));
                return new URL(normalizedUrl);
            }
            catch (MalformedURLException e) {
                if (Reflections.log == null) continue;
                Reflections.log.warn("Could not get URL", (Throwable)e);
            }
        }
        return null;
    }

    public static Collection<URL> forClassLoader() {
        return ReflectionsWorkaroundClasspathHelper.forClassLoader(ReflectionsWorkaroundClasspathHelper.classLoaders(new ClassLoader[0]));
    }

    public static Collection<URL> forClassLoader(ClassLoader ... classLoaders) {
        ClassLoader[] loaders;
        ArrayList<URL> result = new ArrayList<URL>();
        ClassLoader[] arr$ = loaders = ReflectionsWorkaroundClasspathHelper.classLoaders(classLoaders);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (ClassLoader classLoader = arr$[i$]; classLoader != null; classLoader = classLoader.getParent()) {
                Object[] urls;
                if (!(classLoader instanceof URLClassLoader) || (urls = ((URLClassLoader)classLoader).getURLs()) == null) continue;
                result.addAll(Sets.newHashSet((Object[])urls));
            }
        }
        return ReflectionsWorkaroundClasspathHelper.distinctUrls(result);
    }

    public static Collection<URL> forJavaClassPath() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String javaClassPath = System.getProperty("java.class.path");
        if (javaClassPath != null) {
            for (String path : javaClassPath.split(File.pathSeparator)) {
                try {
                    urls.add(new File(path).toURI().toURL());
                }
                catch (Exception e) {
                    if (Reflections.log == null) continue;
                    Reflections.log.warn("Could not get URL", (Throwable)e);
                }
            }
        }
        return ReflectionsWorkaroundClasspathHelper.distinctUrls(urls);
    }

    public static String cleanPath(URL url) {
        String path = url.getPath();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (path.startsWith("jar:")) {
            path = path.substring("jar:".length());
        }
        if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        if (path.endsWith("!/")) {
            path = path.substring(0, path.lastIndexOf("!/")) + "/";
        }
        return path;
    }

    private static String resourceName(String name) {
        if (name != null) {
            String resourceName = name.replace(".", "/");
            if ((resourceName = resourceName.replace("\\", "/")).startsWith("/")) {
                resourceName = resourceName.substring(1);
            }
            return resourceName;
        }
        return null;
    }

    private static Collection<URL> distinctUrls(Collection<URL> urls) {
        HashMap<String, URL> distinct = new HashMap<String, URL>(urls.size());
        for (URL url : urls) {
            distinct.put(url.toExternalForm(), url);
        }
        return distinct.values();
    }
}

