/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoftlong;

import org.optaplanner.core.api.score.AbstractScore;
import org.optaplanner.core.api.score.FeasibilityScore;

public final class HardMediumSoftLongScore
extends AbstractScore<HardMediumSoftLongScore>
implements FeasibilityScore<HardMediumSoftLongScore> {
    private static final String HARD_LABEL = "hard";
    private static final String MEDIUM_LABEL = "medium";
    private static final String SOFT_LABEL = "soft";
    private final long hardScore;
    private final long mediumScore;
    private final long softScore;

    public static HardMediumSoftLongScore parseScore(String scoreString) {
        String[] levelStrings = HardMediumSoftLongScore.parseLevelStrings(HardMediumSoftLongScore.class, scoreString, HARD_LABEL, MEDIUM_LABEL, SOFT_LABEL);
        long hardScore = HardMediumSoftLongScore.parseLevelAsLong(HardMediumSoftLongScore.class, scoreString, levelStrings[0]);
        long mediumScore = HardMediumSoftLongScore.parseLevelAsLong(HardMediumSoftLongScore.class, scoreString, levelStrings[1]);
        long softScore = HardMediumSoftLongScore.parseLevelAsLong(HardMediumSoftLongScore.class, scoreString, levelStrings[2]);
        return HardMediumSoftLongScore.valueOf(hardScore, mediumScore, softScore);
    }

    public static HardMediumSoftLongScore valueOf(long hardScore, long mediumScore, long softScore) {
        return new HardMediumSoftLongScore(hardScore, mediumScore, softScore);
    }

    private HardMediumSoftLongScore() {
        this.hardScore = Long.MIN_VALUE;
        this.mediumScore = Long.MIN_VALUE;
        this.softScore = Long.MIN_VALUE;
    }

    private HardMediumSoftLongScore(long hardScore, long mediumScore, long softScore) {
        this.hardScore = hardScore;
        this.mediumScore = mediumScore;
        this.softScore = softScore;
    }

    public long getHardScore() {
        return this.hardScore;
    }

    public long getMediumScore() {
        return this.mediumScore;
    }

    public long getSoftScore() {
        return this.softScore;
    }

    @Override
    public boolean isFeasible() {
        return this.getHardScore() >= 0L;
    }

    @Override
    public HardMediumSoftLongScore add(HardMediumSoftLongScore augment) {
        return new HardMediumSoftLongScore(this.hardScore + augment.getHardScore(), this.mediumScore + augment.getMediumScore(), this.softScore + augment.getSoftScore());
    }

    @Override
    public HardMediumSoftLongScore subtract(HardMediumSoftLongScore subtrahend) {
        return new HardMediumSoftLongScore(this.hardScore - subtrahend.getHardScore(), this.mediumScore - subtrahend.getMediumScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardMediumSoftLongScore multiply(double multiplicand) {
        return new HardMediumSoftLongScore((long)Math.floor((double)this.hardScore * multiplicand), (long)Math.floor((double)this.mediumScore * multiplicand), (long)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardMediumSoftLongScore divide(double divisor) {
        return new HardMediumSoftLongScore((long)Math.floor((double)this.hardScore / divisor), (long)Math.floor((double)this.mediumScore / divisor), (long)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public HardMediumSoftLongScore power(double exponent) {
        return new HardMediumSoftLongScore((long)Math.floor(Math.pow(this.hardScore, exponent)), (long)Math.floor(Math.pow(this.mediumScore, exponent)), (long)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public HardMediumSoftLongScore negate() {
        return new HardMediumSoftLongScore(-this.hardScore, -this.mediumScore, -this.softScore);
    }

    @Override
    public Number[] toLevelNumbers() {
        return new Number[]{this.hardScore, this.mediumScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardMediumSoftLongScore) {
            HardMediumSoftLongScore other = (HardMediumSoftLongScore)o;
            return this.hardScore == other.getHardScore() && this.mediumScore == other.getMediumScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return ((629 + Long.valueOf(this.hardScore).hashCode()) * 37 + Long.valueOf(this.mediumScore).hashCode()) * 37 + Long.valueOf(this.softScore).hashCode();
    }

    @Override
    public int compareTo(HardMediumSoftLongScore other) {
        if (this.hardScore != other.getHardScore()) {
            if (this.hardScore < other.getHardScore()) {
                return -1;
            }
            return 1;
        }
        if (this.mediumScore != other.getMediumScore()) {
            if (this.mediumScore < other.getMediumScore()) {
                return -1;
            }
            return 1;
        }
        if (this.softScore < other.getSoftScore()) {
            return -1;
        }
        if (this.softScore > other.getSoftScore()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.hardScore + HARD_LABEL + "/" + this.mediumScore + MEDIUM_LABEL + "/" + this.softScore + SOFT_LABEL;
    }
}

