/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase.scope;

import java.util.Random;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPhaseScope<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final SolverScope<Solution_> solverScope;
    protected Long startingSystemTimeMillis;
    protected Long startingScoreCalculationCount;
    protected Score startingScore;
    protected Long endingSystemTimeMillis;
    protected Long endingScoreCalculationCount;
    protected long childThreadsScoreCalculationCount = 0L;
    protected int bestSolutionStepIndex;

    public AbstractPhaseScope(SolverScope<Solution_> solverScope) {
        this.solverScope = solverScope;
    }

    public SolverScope<Solution_> getSolverScope() {
        return this.solverScope;
    }

    public Long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public <Score_ extends Score<Score_>> Score_ getStartingScore() {
        return (Score_)this.startingScore;
    }

    public Long getEndingSystemTimeMillis() {
        return this.endingSystemTimeMillis;
    }

    public int getBestSolutionStepIndex() {
        return this.bestSolutionStepIndex;
    }

    public void setBestSolutionStepIndex(int bestSolutionStepIndex) {
        this.bestSolutionStepIndex = bestSolutionStepIndex;
    }

    public abstract AbstractStepScope<Solution_> getLastCompletedStepScope();

    public void reset() {
        this.bestSolutionStepIndex = -1;
        this.startingScore = this.solverScope.calculateScore();
        if (this.getLastCompletedStepScope().getStepIndex() < 0) {
            this.getLastCompletedStepScope().setScore(this.startingScore);
        }
    }

    public void startingNow() {
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.startingScoreCalculationCount = this.getScoreDirector().getCalculationCount();
    }

    public void endingNow() {
        this.endingSystemTimeMillis = System.currentTimeMillis();
        this.endingScoreCalculationCount = this.getScoreDirector().getCalculationCount();
    }

    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solverScope.getSolutionDescriptor();
    }

    public long calculateSolverTimeMillisSpentUpToNow() {
        return this.solverScope.calculateTimeMillisSpentUpToNow();
    }

    public long calculatePhaseTimeMillisSpentUpToNow() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    public long getPhaseTimeMillisSpent() {
        return this.endingSystemTimeMillis - this.startingSystemTimeMillis;
    }

    public void addChildThreadsScoreCalculationCount(long addition) {
        this.solverScope.addChildThreadsScoreCalculationCount(addition);
        this.childThreadsScoreCalculationCount += addition;
    }

    public long getPhaseScoreCalculationCount() {
        return this.endingScoreCalculationCount - this.startingScoreCalculationCount + this.childThreadsScoreCalculationCount;
    }

    public long getPhaseScoreCalculationSpeed() {
        long timeMillisSpent = this.getPhaseTimeMillisSpent();
        return this.getPhaseScoreCalculationCount() * 1000L / (timeMillisSpent == 0L ? 1L : timeMillisSpent);
    }

    public <Score_ extends Score<Score_>> InnerScoreDirector<Solution_, Score_> getScoreDirector() {
        return this.solverScope.getScoreDirector();
    }

    public Solution_ getWorkingSolution() {
        return this.solverScope.getWorkingSolution();
    }

    public int getWorkingEntityCount() {
        return this.solverScope.getWorkingEntityCount();
    }

    public int getWorkingValueCount() {
        return this.solverScope.getWorkingValueCount();
    }

    public <Score_ extends Score<Score_>> Score_ calculateScore() {
        return (Score_)this.solverScope.calculateScore();
    }

    public <Score_ extends Score<Score_>> void assertExpectedWorkingScore(Score_ expectedWorkingScore, Object completedAction) {
        InnerScoreDirector<Solution_, Score_> innerScoreDirector = this.getScoreDirector();
        innerScoreDirector.assertExpectedWorkingScore(expectedWorkingScore, completedAction);
    }

    public <Score_ extends Score<Score_>> void assertWorkingScoreFromScratch(Score_ workingScore, Object completedAction) {
        InnerScoreDirector<Solution_, Score_> innerScoreDirector = this.getScoreDirector();
        innerScoreDirector.assertWorkingScoreFromScratch(workingScore, completedAction);
    }

    public <Score_ extends Score<Score_>> void assertPredictedScoreFromScratch(Score_ workingScore, Object completedAction) {
        InnerScoreDirector<Solution_, Score_> innerScoreDirector = this.getScoreDirector();
        innerScoreDirector.assertPredictedScoreFromScratch(workingScore, completedAction);
    }

    public <Score_ extends Score<Score_>> void assertShadowVariablesAreNotStale(Score_ workingScore, Object completedAction) {
        InnerScoreDirector<Solution_, Score_> innerScoreDirector = this.getScoreDirector();
        innerScoreDirector.assertShadowVariablesAreNotStale(workingScore, completedAction);
    }

    public Random getWorkingRandom() {
        return this.getSolverScope().getWorkingRandom();
    }

    public boolean isBestSolutionInitialized() {
        return this.solverScope.isBestSolutionInitialized();
    }

    public <Score_ extends Score<Score_>> Score_ getBestScore() {
        return (Score_)this.solverScope.getBestScore();
    }

    public long getPhaseBestSolutionTimeMillis() {
        long bestSolutionTimeMillis = this.solverScope.getBestSolutionTimeMillis();
        if (bestSolutionTimeMillis < this.startingSystemTimeMillis) {
            bestSolutionTimeMillis = this.startingSystemTimeMillis;
        }
        return bestSolutionTimeMillis;
    }

    public int getNextStepIndex() {
        return this.getLastCompletedStepScope().getStepIndex() + 1;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

