/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableDemand;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.list.DestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.OriginalListChangeIterator;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomListChangeIterator;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class ListChangeMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final EntityIndependentValueSelector<Solution_> sourceValueSelector;
    private final DestinationSelector<Solution_> destinationSelector;
    private final boolean randomSelection;
    private SingletonInverseVariableSupply inverseVariableSupply;
    private IndexVariableSupply indexVariableSupply;

    public ListChangeMoveSelector(EntityIndependentValueSelector<Solution_> sourceValueSelector, DestinationSelector<Solution_> destinationSelector, boolean randomSelection) {
        this.sourceValueSelector = sourceValueSelector;
        this.destinationSelector = destinationSelector;
        this.randomSelection = randomSelection;
        this.phaseLifecycleSupport.addEventListener(sourceValueSelector);
        this.phaseLifecycleSupport.addEventListener(destinationSelector);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)this.sourceValueSelector.getVariableDescriptor();
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.inverseVariableSupply = supplyManager.demand(new SingletonListInverseVariableDemand(listVariableDescriptor));
        this.indexVariableSupply = supplyManager.demand(new IndexVariableDemand(listVariableDescriptor));
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.indexVariableSupply = null;
    }

    @Override
    public long getSize() {
        return this.sourceValueSelector.getSize() * this.destinationSelector.getSize();
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (this.randomSelection) {
            return new RandomListChangeIterator<Solution_>(this.inverseVariableSupply, this.indexVariableSupply, this.sourceValueSelector, this.destinationSelector);
        }
        return new OriginalListChangeIterator<Solution_>(this.inverseVariableSupply, this.indexVariableSupply, this.sourceValueSelector, this.destinationSelector);
    }

    @Override
    public boolean isCountable() {
        return this.sourceValueSelector.isCountable() && this.destinationSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.sourceValueSelector.isNeverEnding() || this.destinationSelector.isNeverEnding();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceValueSelector + ", " + this.destinationSelector + ")";
    }
}

