/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.list.nearby;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableDemand;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbySelector;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.list.DestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.ElementDestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.ElementRef;
import org.optaplanner.core.impl.heuristic.selector.list.SubList;
import org.optaplanner.core.impl.heuristic.selector.list.SubListSelector;
import org.optaplanner.core.impl.heuristic.selector.list.mimic.MimicReplayingSubListSelector;
import org.optaplanner.core.impl.heuristic.selector.list.nearby.SubListNearbyDistanceMatrixDemand;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public final class NearSubListNearbyDestinationSelector<Solution_>
extends AbstractNearbySelector<Solution_, ElementDestinationSelector<Solution_>, MimicReplayingSubListSelector<Solution_>>
implements DestinationSelector<Solution_> {
    private SingletonInverseVariableSupply inverseVariableSupply;
    private IndexVariableSupply indexVariableSupply;

    public NearSubListNearbyDestinationSelector(ElementDestinationSelector<Solution_> childDestinationSelector, SubListSelector<Solution_> originSubListSelector, NearbyDistanceMeter<?, ?> nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        super(childDestinationSelector, originSubListSelector, nearbyDistanceMeter, nearbyRandom, randomSelection);
    }

    @Override
    protected MimicReplayingSubListSelector<Solution_> castReplayingSelector(Object uncastReplayingSelector) {
        if (!(uncastReplayingSelector instanceof MimicReplayingSubListSelector)) {
            throw new IllegalStateException("Impossible state: Nearby destination selector (" + this + ") did not receive a replaying subList selector (" + uncastReplayingSelector + ").");
        }
        return (MimicReplayingSubListSelector)uncastReplayingSelector;
    }

    @Override
    protected AbstractNearbyDistanceMatrixDemand<?, ?, ?, ?> createDemand() {
        return new SubListNearbyDistanceMatrixDemand(this.nearbyDistanceMeter, this.nearbyRandom, (ElementDestinationSelector)this.childSelector, (MimicReplayingSubListSelector)this.replayingSelector, this::computeDestinationSize);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        ListVariableDescriptor listVariableDescriptor = ((ElementDestinationSelector)this.childSelector).getVariableDescriptor();
        this.inverseVariableSupply = supplyManager.demand(new SingletonListInverseVariableDemand(listVariableDescriptor));
        this.indexVariableSupply = supplyManager.demand(new IndexVariableDemand(listVariableDescriptor));
    }

    private int computeDestinationSize(Object origin) {
        int overallSizeMaximum;
        long childSize = ((ElementDestinationSelector)this.childSelector).getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childDestinationSelector (" + this.childSelector + ") has a destinationSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        int destinationSize = (int)childSize;
        if (this.randomSelection && destinationSize > (overallSizeMaximum = this.nearbyRandom.getOverallSizeMaximum())) {
            destinationSize = overallSizeMaximum;
        }
        return destinationSize;
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.indexVariableSupply = null;
    }

    @Override
    public boolean isCountable() {
        return ((ElementDestinationSelector)this.childSelector).isCountable();
    }

    @Override
    public long getSize() {
        return ((ElementDestinationSelector)this.childSelector).getSize();
    }

    @Override
    public Iterator<ElementRef> iterator() {
        Iterator<SubList> replayingOriginSubListIterator = ((MimicReplayingSubListSelector)this.replayingSelector).iterator();
        if (!this.randomSelection) {
            return new OriginalSubListNearbyDestinationIterator(replayingOriginSubListIterator, ((ElementDestinationSelector)this.childSelector).getSize());
        }
        return new RandomSubListNearbyDestinationIterator(replayingOriginSubListIterator, ((ElementDestinationSelector)this.childSelector).getSize());
    }

    private Object firstElement(SubList subList) {
        return ((MimicReplayingSubListSelector)this.replayingSelector).getVariableDescriptor().getElement(subList.getEntity(), subList.getFromIndex());
    }

    private ElementRef elementRef(Object next) {
        if (((ElementDestinationSelector)this.childSelector).getEntityDescriptor().matchesEntity(next)) {
            return ElementRef.of(next, 0);
        }
        return ElementRef.of(this.inverseVariableSupply.getInverseSingleton(next), this.indexVariableSupply.getIndex(next) + 1);
    }

    private final class OriginalSubListNearbyDestinationIterator
    extends SelectionIterator<ElementRef> {
        private final Iterator<SubList> replayingOriginSubListIterator;
        private final long childSize;
        private boolean originSelected = false;
        private boolean originIsNotEmpty;
        private Object origin;
        private int nextNearbyIndex;

        public OriginalSubListNearbyDestinationIterator(Iterator<SubList> replayingOriginSubListIterator, long childSize) {
            this.replayingOriginSubListIterator = replayingOriginSubListIterator;
            this.childSize = childSize;
            this.nextNearbyIndex = 0;
        }

        private void selectOrigin() {
            if (this.originSelected) {
                return;
            }
            this.originIsNotEmpty = this.replayingOriginSubListIterator.hasNext();
            SubList subList = this.replayingOriginSubListIterator.next();
            this.origin = NearSubListNearbyDestinationSelector.this.firstElement(subList);
            this.originSelected = true;
        }

        @Override
        public boolean hasNext() {
            this.selectOrigin();
            return this.originIsNotEmpty && (long)this.nextNearbyIndex < this.childSize;
        }

        @Override
        public ElementRef next() {
            this.selectOrigin();
            Object next = ((NearbyDistanceMatrix)NearSubListNearbyDestinationSelector.this.nearbyDistanceMatrixSupply.read()).getDestination(this.origin, this.nextNearbyIndex);
            ++this.nextNearbyIndex;
            return NearSubListNearbyDestinationSelector.this.elementRef(next);
        }
    }

    private final class RandomSubListNearbyDestinationIterator
    extends SelectionIterator<ElementRef> {
        private final Iterator<SubList> replayingOriginSubListIterator;
        private final int nearbySize;

        public RandomSubListNearbyDestinationIterator(Iterator<SubList> replayingOriginSubListIterator, long childSize) {
            this.replayingOriginSubListIterator = replayingOriginSubListIterator;
            if (childSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The destinationSelector (" + this + ") has a destinationSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
            }
            this.nearbySize = (int)childSize;
        }

        @Override
        public boolean hasNext() {
            return this.replayingOriginSubListIterator.hasNext() && this.nearbySize > 0;
        }

        @Override
        public ElementRef next() {
            SubList subList = this.replayingOriginSubListIterator.next();
            Object origin = NearSubListNearbyDestinationSelector.this.firstElement(subList);
            int nearbyIndex = NearSubListNearbyDestinationSelector.this.nearbyRandom.nextInt(NearSubListNearbyDestinationSelector.this.workingRandom, this.nearbySize);
            Object next = ((NearbyDistanceMatrix)NearSubListNearbyDestinationSelector.this.nearbyDistanceMatrixSupply.read()).getDestination(origin, nearbyIndex);
            return NearSubListNearbyDestinationSelector.this.elementRef(next);
        }
    }
}

