/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.phase.AbstractPhase;
import org.optaplanner.core.impl.phase.Phase;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleSupport;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.event.SolverEventSupport;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.scope.SolverScope;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolver<Solution_>
implements Solver<Solution_> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SolverEventSupport<Solution_> solverEventSupport = new SolverEventSupport(this);
    private final PhaseLifecycleSupport<Solution_> phaseLifecycleSupport = new PhaseLifecycleSupport();
    protected final BestSolutionRecaller<Solution_> bestSolutionRecaller;
    protected final Termination<Solution_> solverTermination;
    protected final List<Phase<Solution_>> phaseList;

    public AbstractSolver(BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination<Solution_> solverTermination, List<Phase<Solution_>> phaseList) {
        this.bestSolutionRecaller = bestSolutionRecaller;
        this.solverTermination = solverTermination;
        bestSolutionRecaller.setSolverEventSupport(this.solverEventSupport);
        this.phaseList = phaseList;
        phaseList.forEach(phase -> ((AbstractPhase)phase).setSolver(this));
    }

    public void solvingStarted(SolverScope<Solution_> solverScope) {
        solverScope.setWorkingSolutionFromBestSolution();
        this.bestSolutionRecaller.solvingStarted(solverScope);
        this.solverTermination.solvingStarted(solverScope);
        this.phaseLifecycleSupport.fireSolvingStarted(solverScope);
        for (Phase<Solution_> phase : this.phaseList) {
            phase.solvingStarted(solverScope);
        }
    }

    protected void runPhases(SolverScope<Solution_> solverScope) {
        if (!solverScope.getSolutionDescriptor().hasMovableEntities(solverScope.getScoreDirector())) {
            this.logger.info("Skipped all phases ({}): out of {} planning entities, none are movable (non-pinned).", (Object)this.phaseList.size(), (Object)solverScope.getSolutionDescriptor().getEntityCount(solverScope.getWorkingSolution()));
            return;
        }
        Iterator<Phase<Solution_>> it = this.phaseList.iterator();
        while (!this.solverTermination.isSolverTerminated(solverScope) && it.hasNext()) {
            Phase<Solution_> phase = it.next();
            phase.solve(solverScope);
            if (!it.hasNext()) continue;
            solverScope.setWorkingSolutionFromBestSolution();
        }
    }

    public void solvingEnded(SolverScope<Solution_> solverScope) {
        for (Phase<Solution_> phase : this.phaseList) {
            phase.solvingEnded(solverScope);
        }
        this.bestSolutionRecaller.solvingEnded(solverScope);
        this.solverTermination.solvingEnded(solverScope);
        this.phaseLifecycleSupport.fireSolvingEnded(solverScope);
    }

    public void solvingError(SolverScope<Solution_> solverScope, Exception exception) {
        this.phaseLifecycleSupport.fireSolvingError(solverScope, exception);
        for (Phase<Solution_> phase : this.phaseList) {
            phase.solvingError(solverScope, exception);
        }
    }

    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        this.bestSolutionRecaller.phaseStarted(phaseScope);
        this.phaseLifecycleSupport.firePhaseStarted(phaseScope);
        this.solverTermination.phaseStarted(phaseScope);
    }

    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        this.bestSolutionRecaller.phaseEnded(phaseScope);
        this.phaseLifecycleSupport.firePhaseEnded(phaseScope);
        this.solverTermination.phaseEnded(phaseScope);
    }

    public void stepStarted(AbstractStepScope<Solution_> stepScope) {
        this.bestSolutionRecaller.stepStarted(stepScope);
        this.phaseLifecycleSupport.fireStepStarted(stepScope);
        this.solverTermination.stepStarted(stepScope);
    }

    public void stepEnded(AbstractStepScope<Solution_> stepScope) {
        this.bestSolutionRecaller.stepEnded(stepScope);
        this.phaseLifecycleSupport.fireStepEnded(stepScope);
        this.solverTermination.stepEnded(stepScope);
    }

    @Override
    public void addEventListener(SolverEventListener<Solution_> eventListener) {
        this.solverEventSupport.addEventListener(eventListener);
    }

    @Override
    public void removeEventListener(SolverEventListener<Solution_> eventListener) {
        this.solverEventSupport.removeEventListener(eventListener);
    }

    public void addPhaseLifecycleListener(PhaseLifecycleListener<Solution_> phaseLifecycleListener) {
        this.phaseLifecycleSupport.addEventListener(phaseLifecycleListener);
    }

    public void removePhaseLifecycleListener(PhaseLifecycleListener<Solution_> phaseLifecycleListener) {
        this.phaseLifecycleSupport.removeEventListener(phaseLifecycleListener);
    }

    public BestSolutionRecaller<Solution_> getBestSolutionRecaller() {
        return this.bestSolutionRecaller;
    }

    public List<Phase<Solution_>> getPhaseList() {
        return this.phaseList;
    }
}

