/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.Iterator;
import java.util.Objects;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.AbstractCachingValueSelector;

public final class CachingValueSelector<Solution_>
extends AbstractCachingValueSelector<Solution_>
implements EntityIndependentValueSelector<Solution_> {
    protected final boolean randomSelection;

    public CachingValueSelector(EntityIndependentValueSelector<Solution_> childValueSelector, SelectionCacheType cacheType, boolean randomSelection) {
        super(childValueSelector, cacheType);
        this.randomSelection = randomSelection;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        if (!this.randomSelection) {
            return this.cachedValueList.iterator();
        }
        return new CachedListRandomIterator<Object>(this.cachedValueList, this.workingRandom);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        CachingValueSelector that = (CachingValueSelector)other;
        return this.randomSelection == that.randomSelection;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.randomSelection);
    }

    public String toString() {
        return "Caching(" + this.childValueSelector + ")";
    }
}

