/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.FlipSublistAction;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.util.CollectionUtils;

final class TwoOptListMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableDescriptor<Solution_> variableDescriptor;
    private final Object firstEntity;
    private final Object secondEntity;
    private final int firstEdgeEndpoint;
    private final int secondEdgeEndpoint;
    private final int shift;

    public TwoOptListMove(ListVariableDescriptor<Solution_> variableDescriptor, Object firstEntity, Object secondEntity, int firstEdgeEndpoint, int secondEdgeEndpoint) {
        this.variableDescriptor = variableDescriptor;
        this.firstEntity = firstEntity;
        this.secondEntity = secondEntity;
        this.firstEdgeEndpoint = firstEdgeEndpoint;
        this.secondEdgeEndpoint = secondEdgeEndpoint;
        if (firstEntity == secondEntity) {
            if (firstEdgeEndpoint == 0) {
                this.shift = -secondEdgeEndpoint;
            } else if (secondEdgeEndpoint < firstEdgeEndpoint) {
                int listSize = variableDescriptor.getListSize(firstEntity);
                int flippedSectionSize = listSize - firstEdgeEndpoint + secondEdgeEndpoint;
                int firstElementIndexInFlipped = listSize - firstEdgeEndpoint;
                int firstElementMirroredIndex = flippedSectionSize - firstElementIndexInFlipped;
                this.shift = -(firstEdgeEndpoint + firstElementMirroredIndex - 1);
            } else {
                this.shift = 0;
            }
        } else {
            this.shift = 0;
        }
    }

    public TwoOptListMove(ListVariableDescriptor<Solution_> variableDescriptor, Object firstEntity, Object secondEntity, int firstEdgeEndpoint, int secondEdgeEndpoint, int shift) {
        this.variableDescriptor = variableDescriptor;
        this.firstEntity = firstEntity;
        this.secondEntity = secondEntity;
        this.firstEdgeEndpoint = firstEdgeEndpoint;
        this.secondEdgeEndpoint = secondEdgeEndpoint;
        this.shift = shift;
    }

    @Override
    protected TwoOptListMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        return new TwoOptListMove<Solution_>(this.variableDescriptor, this.firstEntity, this.secondEntity, this.firstEdgeEndpoint, this.secondEdgeEndpoint, -this.shift);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        if (this.firstEntity == this.secondEntity) {
            this.doSublistReversal(scoreDirector);
        } else {
            this.doTailSwap(scoreDirector);
        }
    }

    private void doTailSwap(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        List<Object> firstListVariable = this.variableDescriptor.getListVariable(this.firstEntity);
        List<Object> secondListVariable = this.variableDescriptor.getListVariable(this.secondEntity);
        int firstOriginalSize = firstListVariable.size();
        int secondOriginalSize = secondListVariable.size();
        innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.firstEntity, this.firstEdgeEndpoint, firstOriginalSize);
        innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.secondEntity, this.secondEdgeEndpoint, secondOriginalSize);
        List<Object> firstListVariableTail = firstListVariable.subList(this.firstEdgeEndpoint, firstOriginalSize);
        List<Object> secondListVariableTail = secondListVariable.subList(this.secondEdgeEndpoint, secondOriginalSize);
        int tailSizeDifference = secondListVariableTail.size() - firstListVariableTail.size();
        ArrayList<Object> firstListVariableTailCopy = new ArrayList<Object>(firstListVariableTail);
        firstListVariableTail.clear();
        firstListVariable.addAll(secondListVariableTail);
        secondListVariableTail.clear();
        secondListVariable.addAll(firstListVariableTailCopy);
        innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.firstEntity, this.firstEdgeEndpoint, firstOriginalSize + tailSizeDifference);
        innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.secondEntity, this.secondEdgeEndpoint, secondOriginalSize - tailSizeDifference);
    }

    private void doSublistReversal(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        List<Object> listVariable = this.variableDescriptor.getListVariable(this.firstEntity);
        if (this.firstEdgeEndpoint < this.secondEdgeEndpoint) {
            if (this.firstEdgeEndpoint > 0) {
                innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.firstEntity, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
            } else {
                innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.firstEntity, 0, listVariable.size());
            }
            if (this.firstEdgeEndpoint == 0 && this.shift > 0) {
                Collections.rotate(listVariable, this.shift);
            }
            FlipSublistAction.flipSublist(listVariable, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
            if (this.firstEdgeEndpoint == 0 && this.shift < 0) {
                Collections.rotate(listVariable, this.shift);
            }
            if (this.firstEdgeEndpoint > 0) {
                innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.firstEntity, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
            } else {
                innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.firstEntity, 0, listVariable.size());
            }
        } else {
            innerScoreDirector.beforeListVariableChanged(this.variableDescriptor, this.firstEntity, 0, listVariable.size());
            if (this.shift > 0) {
                Collections.rotate(listVariable, this.shift);
            }
            FlipSublistAction.flipSublist(listVariable, this.firstEdgeEndpoint, this.secondEdgeEndpoint);
            if (this.shift < 0) {
                Collections.rotate(listVariable, this.shift);
            }
            innerScoreDirector.afterListVariableChanged(this.variableDescriptor, this.firstEntity, 0, listVariable.size());
        }
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return true;
    }

    @Override
    public TwoOptListMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new TwoOptListMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.firstEntity), destinationScoreDirector.lookUpWorkingObject(this.secondEntity), this.firstEdgeEndpoint, this.secondEdgeEndpoint, this.shift);
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return "2-Opt(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return Set.of(this.firstEntity, this.secondEntity);
    }

    @Override
    public Collection<?> getPlanningValues() {
        if (this.firstEntity == this.secondEntity) {
            List<Object> listVariable = this.variableDescriptor.getListVariable(this.firstEntity);
            if (this.firstEdgeEndpoint < this.secondEdgeEndpoint) {
                return new ArrayList<Object>(listVariable.subList(this.firstEdgeEndpoint, this.secondEdgeEndpoint));
            }
            List<Object> firstHalfReversedPath = listVariable.subList(this.firstEdgeEndpoint, listVariable.size());
            List<Object> secondHalfReversedPath = listVariable.subList(0, this.secondEdgeEndpoint);
            return CollectionUtils.concat(firstHalfReversedPath, secondHalfReversedPath);
        }
        List<Object> firstListVariable = this.variableDescriptor.getListVariable(this.firstEntity);
        List<Object> secondListVariable = this.variableDescriptor.getListVariable(this.secondEntity);
        List<Object> firstListVariableTail = firstListVariable.subList(this.firstEdgeEndpoint, firstListVariable.size());
        List<Object> secondListVariableTail = secondListVariable.subList(this.secondEdgeEndpoint, secondListVariable.size());
        ArrayList<Object> out = new ArrayList<Object>(firstListVariableTail.size() + secondListVariableTail.size());
        out.addAll(firstListVariableTail);
        out.addAll(secondListVariableTail);
        return out;
    }

    public Object getFirstEntity() {
        return this.firstEntity;
    }

    public Object getSecondEntity() {
        return this.secondEntity;
    }

    public Object getFirstEdgeEndpoint() {
        return this.firstEdgeEndpoint;
    }

    public Object getSecondEdgeEndpoint() {
        return this.secondEdgeEndpoint;
    }

    public String toString() {
        return "2-Opt(firstEntity=" + this.firstEntity + ", secondEntity=" + this.secondEntity + ", firstEndpointIndex=" + this.firstEdgeEndpoint + ", secondEndpointIndex=" + this.secondEdgeEndpoint + ")";
    }
}

