/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.FlipSublistAction;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptListMove;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptUtils;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.MultipleDelegateList;

final class KOptDescriptor<Node_> {
    private final int k;
    private final Node_[] removedEdges;
    private final int[] removedEdgeIndexToTourOrder;
    private final int[] inverseRemovedEdgeIndexToTourOrder;
    private final int[] addedEdgeToOtherEndpoint;

    static <Node_> int[] computeInEdgesForSequentialMove(Node_[] removedEdges) {
        int[] out = new int[removedEdges.length];
        int k = removedEdges.length - 1 >> 1;
        out[1] = removedEdges.length - 1;
        out[removedEdges.length - 1] = 1;
        for (int i = 1; i < k; ++i) {
            out[2 * i + 1] = 2 * i;
            out[2 * i] = 2 * i + 1;
        }
        return out;
    }

    public KOptDescriptor(Node_[] removedEdges, Function<Node_, Node_> endpointToSuccessorFunction, TriPredicate<Node_, Node_, Node_> betweenPredicate) {
        this(removedEdges, KOptDescriptor.computeInEdgesForSequentialMove(removedEdges), endpointToSuccessorFunction, betweenPredicate);
    }

    public KOptDescriptor(Node_[] removedEdges, int[] addedEdgeToOtherEndpoint, Function<Node_, Node_> endpointToSuccessorFunction, TriPredicate<Node_, Node_, Node_> betweenPredicate) {
        int i;
        this.k = removedEdges.length - 1 >> 1;
        this.removedEdges = removedEdges;
        this.removedEdgeIndexToTourOrder = new int[removedEdges.length];
        this.inverseRemovedEdgeIndexToTourOrder = new int[removedEdges.length];
        this.addedEdgeToOtherEndpoint = addedEdgeToOtherEndpoint;
        int i2 = 1;
        for (int j = 1; j <= this.k; ++j) {
            this.removedEdgeIndexToTourOrder[j] = endpointToSuccessorFunction.apply(removedEdges[i2]) == removedEdges[i2 + 1] ? i2 : i2 + 1;
            i2 += 2;
        }
        Comparator comparator = (pa, pb) -> pa.equals(pb) ? 0 : (betweenPredicate.test(removedEdges[this.removedEdgeIndexToTourOrder[1]], removedEdges[pa], removedEdges[pb]) ? -1 : 1);
        Integer[] wrappedRemovedEdgeIndexToTourOrder = (Integer[])IntStream.of(this.removedEdgeIndexToTourOrder).boxed().toArray(Integer[]::new);
        Arrays.sort(wrappedRemovedEdgeIndexToTourOrder, 2, this.k + 1, comparator);
        for (i = 0; i < this.removedEdgeIndexToTourOrder.length; ++i) {
            this.removedEdgeIndexToTourOrder[i] = wrappedRemovedEdgeIndexToTourOrder[i];
        }
        for (int j = 2 * this.k; j >= 2; j -= 2) {
            this.removedEdgeIndexToTourOrder[j - 1] = i = this.removedEdgeIndexToTourOrder[j / 2];
            this.removedEdgeIndexToTourOrder[j] = (i & 1) == 1 ? i + 1 : i - 1;
        }
        for (i = 1; i <= 2 * this.k; ++i) {
            this.inverseRemovedEdgeIndexToTourOrder[this.removedEdgeIndexToTourOrder[i]] = i;
        }
    }

    int getK() {
        return this.k;
    }

    Node_[] getRemovedEdges() {
        return this.removedEdges;
    }

    int[] getRemovedEdgeIndexToTourOrder() {
        return this.removedEdgeIndexToTourOrder;
    }

    int[] getInverseRemovedEdgeIndexToTourOrder() {
        return this.inverseRemovedEdgeIndexToTourOrder;
    }

    int[] getAddedEdgeToOtherEndpoint() {
        return this.addedEdgeToOtherEndpoint;
    }

    public <Solution_> KOptListMove<Solution_> getKOptListMove(ListVariableDescriptor<Solution_> listVariableDescriptor, IndexVariableSupply originalIndexVariableSupply, SingletonInverseVariableSupply inverseVariableSupply) {
        if (!this.isFeasible()) {
            return new KOptListMove<Solution_>(listVariableDescriptor, inverseVariableSupply, this, List.of(), 0, new int[0]);
        }
        MultipleDelegateList combinedList = this.computeCombinedList(listVariableDescriptor, inverseVariableSupply);
        IndexVariableSupply indexVariableSupply = node -> combinedList.getIndexOfValue(listVariableDescriptor, inverseVariableSupply, originalIndexVariableSupply, node);
        int entityListSize = combinedList.size();
        ArrayList<FlipSublistAction> out = new ArrayList<FlipSublistAction>();
        int[] originalToCurrentIndexList = new int[entityListSize];
        for (int index2 = 0; index2 < entityListSize; ++index2) {
            originalToCurrentIndexList[index2] = index2;
        }
        boolean isMoveNotDone = true;
        int bestOrientedPairFirstEndpoint = -1;
        int bestOrientedPairSecondEndpoint = -1;
        int[] currentRemovedEdgeIndexToTourOrder = Arrays.copyOf(this.removedEdgeIndexToTourOrder, this.removedEdgeIndexToTourOrder.length);
        int[] currentInverseRemovedEdgeIndexToTourOrder = Arrays.copyOf(this.inverseRemovedEdgeIndexToTourOrder, this.inverseRemovedEdgeIndexToTourOrder.length);
        block1: while (isMoveNotDone) {
            int secondEndpoint;
            int nextEndpointTourIndex;
            int firstEndpointCurrentTourIndex;
            int firstEndpoint;
            int maximumOrientedPairCountAfterReversal = -1;
            for (firstEndpoint = 1; firstEndpoint <= 2 * this.k - 2; ++firstEndpoint) {
                int orientedPairCountAfterReversal;
                firstEndpointCurrentTourIndex = currentRemovedEdgeIndexToTourOrder[firstEndpoint];
                nextEndpointTourIndex = this.addedEdgeToOtherEndpoint[firstEndpointCurrentTourIndex];
                secondEndpoint = currentInverseRemovedEdgeIndexToTourOrder[nextEndpointTourIndex];
                if (secondEndpoint < firstEndpoint + 2 || (firstEndpoint & 1) != (secondEndpoint & 1)) continue;
                int n = orientedPairCountAfterReversal = (firstEndpoint & 1) == 1 ? this.countOrientedPairsForReversal(currentRemovedEdgeIndexToTourOrder, currentInverseRemovedEdgeIndexToTourOrder, firstEndpoint + 1, secondEndpoint) : this.countOrientedPairsForReversal(currentRemovedEdgeIndexToTourOrder, currentInverseRemovedEdgeIndexToTourOrder, firstEndpoint, secondEndpoint - 1);
                if (orientedPairCountAfterReversal <= maximumOrientedPairCountAfterReversal) continue;
                maximumOrientedPairCountAfterReversal = orientedPairCountAfterReversal;
                bestOrientedPairFirstEndpoint = firstEndpoint;
                bestOrientedPairSecondEndpoint = secondEndpoint;
            }
            if (maximumOrientedPairCountAfterReversal >= 0) {
                if ((bestOrientedPairFirstEndpoint & 1) == 1) {
                    out.add(KOptDescriptor.getListReversalMoveForEdgePair(listVariableDescriptor, inverseVariableSupply, indexVariableSupply, combinedList, originalToCurrentIndexList, this.removedEdges[currentRemovedEdgeIndexToTourOrder[bestOrientedPairFirstEndpoint + 1]], this.removedEdges[currentRemovedEdgeIndexToTourOrder[bestOrientedPairFirstEndpoint]], this.removedEdges[currentRemovedEdgeIndexToTourOrder[bestOrientedPairSecondEndpoint]], this.removedEdges[currentRemovedEdgeIndexToTourOrder[bestOrientedPairSecondEndpoint + 1]]));
                    this.reversePermutationPart(currentRemovedEdgeIndexToTourOrder, currentInverseRemovedEdgeIndexToTourOrder, bestOrientedPairFirstEndpoint + 1, bestOrientedPairSecondEndpoint);
                    continue;
                }
                out.add(KOptDescriptor.getListReversalMoveForEdgePair(listVariableDescriptor, inverseVariableSupply, indexVariableSupply, combinedList, originalToCurrentIndexList, this.removedEdges[currentRemovedEdgeIndexToTourOrder[bestOrientedPairFirstEndpoint - 1]], this.removedEdges[currentRemovedEdgeIndexToTourOrder[bestOrientedPairFirstEndpoint]], this.removedEdges[currentRemovedEdgeIndexToTourOrder[bestOrientedPairSecondEndpoint]], this.removedEdges[currentRemovedEdgeIndexToTourOrder[bestOrientedPairSecondEndpoint - 1]]));
                this.reversePermutationPart(currentRemovedEdgeIndexToTourOrder, currentInverseRemovedEdgeIndexToTourOrder, bestOrientedPairFirstEndpoint, bestOrientedPairSecondEndpoint - 1);
                continue;
            }
            for (firstEndpoint = 1; firstEndpoint <= 2 * this.k - 1; firstEndpoint += 2) {
                firstEndpointCurrentTourIndex = currentRemovedEdgeIndexToTourOrder[firstEndpoint];
                nextEndpointTourIndex = this.addedEdgeToOtherEndpoint[firstEndpointCurrentTourIndex];
                secondEndpoint = currentInverseRemovedEdgeIndexToTourOrder[nextEndpointTourIndex];
                if (secondEndpoint < firstEndpoint + 2) continue;
                out.add(KOptDescriptor.getListReversalMoveForEdgePair(listVariableDescriptor, inverseVariableSupply, indexVariableSupply, combinedList, originalToCurrentIndexList, this.removedEdges[currentRemovedEdgeIndexToTourOrder[firstEndpoint]], this.removedEdges[currentRemovedEdgeIndexToTourOrder[firstEndpoint + 1]], this.removedEdges[currentRemovedEdgeIndexToTourOrder[secondEndpoint]], this.removedEdges[currentRemovedEdgeIndexToTourOrder[secondEndpoint - 1]]));
                this.reversePermutationPart(currentRemovedEdgeIndexToTourOrder, currentInverseRemovedEdgeIndexToTourOrder, firstEndpoint + 1, secondEndpoint - 1);
                continue block1;
            }
            isMoveNotDone = false;
        }
        int startElementShift = -KOptDescriptor.indexOf(originalToCurrentIndexList, 0);
        int[] newEndIndices = new int[combinedList.delegates.length];
        int totalOffset = 0;
        for (int i = 0; i < newEndIndices.length; ++i) {
            int listSize = combinedList.delegateSizes[i];
            newEndIndices[i] = totalOffset + listSize - 1;
            totalOffset += listSize;
        }
        newEndIndices = IntStream.of(newEndIndices).map(index -> KOptDescriptor.indexOf(originalToCurrentIndexList, index)).sorted().toArray();
        newEndIndices[newEndIndices.length - 1] = originalToCurrentIndexList.length - 1;
        return new KOptListMove<Solution_>(listVariableDescriptor, inverseVariableSupply, this, out, startElementShift, newEndIndices);
    }

    public boolean isFeasible() {
        int count = 0;
        int currentEndpoint = 2 * this.k;
        while (currentEndpoint != 0) {
            ++count;
            int currentEndpointTourIndex = this.removedEdgeIndexToTourOrder[currentEndpoint];
            int nextEndpointTourIndex = this.addedEdgeToOtherEndpoint[currentEndpointTourIndex];
            currentEndpoint = this.inverseRemovedEdgeIndexToTourOrder[nextEndpointTourIndex] ^ 1;
        }
        return count == this.k;
    }

    private void reversePermutationPart(int[] currentRemovedEdgeIndexToTourOrder, int[] currentInverseRemovedEdgeIndexToTourOrder, int startInclusive, int endExclusive) {
        while (startInclusive < endExclusive) {
            int savedFirstElement = currentRemovedEdgeIndexToTourOrder[startInclusive];
            currentRemovedEdgeIndexToTourOrder[startInclusive] = currentRemovedEdgeIndexToTourOrder[endExclusive];
            currentInverseRemovedEdgeIndexToTourOrder[currentRemovedEdgeIndexToTourOrder[endExclusive]] = startInclusive++;
            currentRemovedEdgeIndexToTourOrder[endExclusive] = savedFirstElement;
            currentInverseRemovedEdgeIndexToTourOrder[savedFirstElement] = endExclusive--;
        }
    }

    private int countOrientedPairsForReversal(int[] currentRemovedEdgeIndexToTourOrder, int[] currentInverseRemovedEdgeIndexToTourOrder, int left, int right) {
        int count = 0;
        this.reversePermutationPart(currentRemovedEdgeIndexToTourOrder, currentInverseRemovedEdgeIndexToTourOrder, left, right);
        for (int i = 1; i <= 2 * this.k - 2; ++i) {
            int currentTourIndex = currentRemovedEdgeIndexToTourOrder[i];
            int otherEndpointTourIndex = this.addedEdgeToOtherEndpoint[currentTourIndex];
            int j = currentInverseRemovedEdgeIndexToTourOrder[otherEndpointTourIndex];
            if (j < i + 2 || (i & 1) != (j & 1)) continue;
            ++count;
        }
        this.reversePermutationPart(currentRemovedEdgeIndexToTourOrder, currentInverseRemovedEdgeIndexToTourOrder, left, right);
        return count;
    }

    private static <Node_> FlipSublistAction getListReversalMoveForEdgePair(ListVariableDescriptor<?> listVariableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, IndexVariableSupply indexVariableSupply, MultipleDelegateList<Node_> combinedList, int[] originalToCurrentIndexList, Node_ firstEdgeStart, Node_ firstEdgeEnd, Node_ secondEdgeStart, Node_ secondEdgeEnd) {
        int originalFirstEdgeStartIndex = KOptDescriptor.indexOf(originalToCurrentIndexList, indexVariableSupply.getIndex(firstEdgeStart));
        int originalFirstEdgeEndIndex = KOptDescriptor.indexOf(originalToCurrentIndexList, indexVariableSupply.getIndex(firstEdgeEnd));
        int originalSecondEdgeStartIndex = KOptDescriptor.indexOf(originalToCurrentIndexList, indexVariableSupply.getIndex(secondEdgeStart));
        int originalSecondEdgeEndIndex = KOptDescriptor.indexOf(originalToCurrentIndexList, indexVariableSupply.getIndex(secondEdgeEnd));
        int firstEndpoint = (originalFirstEdgeStartIndex + 1) % originalToCurrentIndexList.length == originalFirstEdgeEndIndex ? originalFirstEdgeEndIndex : originalFirstEdgeStartIndex;
        int secondEndpoint = (originalSecondEdgeStartIndex + 1) % originalToCurrentIndexList.length == originalSecondEdgeEndIndex ? originalSecondEdgeEndIndex : originalSecondEdgeStartIndex;
        KOptUtils.flipSubarray(originalToCurrentIndexList, firstEndpoint, secondEndpoint);
        return new FlipSublistAction(listVariableDescriptor, inverseVariableSupply, combinedList, firstEndpoint, secondEndpoint);
    }

    private MultipleDelegateList<Node_> computeCombinedList(ListVariableDescriptor<?> listVariableDescriptor, SingletonInverseVariableSupply inverseVariableSupply) {
        IdentityHashMap<Object, Integer> entityToEntityIndex = new IdentityHashMap<Object, Integer>();
        for (int i = 1; i < this.removedEdges.length; ++i) {
            entityToEntityIndex.computeIfAbsent(inverseVariableSupply.getInverseSingleton(this.removedEdges[i]), entity -> entityToEntityIndex.size());
        }
        List[] entityLists = new List[entityToEntityIndex.size()];
        for (Map.Entry entry : entityToEntityIndex.entrySet()) {
            entityLists[((Integer)entry.getValue()).intValue()] = listVariableDescriptor.getListVariable(entry.getKey());
        }
        return new MultipleDelegateList(entityLists);
    }

    private static int indexOf(int[] search, int query) {
        for (int i = 0; i < search.length; ++i) {
            if (search[i] != query) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.k + "-opt(removed=" + KOptUtils.getRemovedEdgeList(this) + "\n, added=" + KOptUtils.getAddedEdgeList(this) + ")";
    }
}

