/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt;

import java.util.Collections;
import java.util.List;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptAffectedElements;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.MultipleDelegateList;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

final class FlipSublistAction {
    private final ListVariableDescriptor<?> variableDescriptor;
    private final MultipleDelegateList<Object> combinedList;
    private final SingletonInverseVariableSupply inverseVariableSupply;
    private final int fromIndexInclusive;
    private final int toIndexExclusive;

    public FlipSublistAction(ListVariableDescriptor<?> variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, MultipleDelegateList<Object> combinedList, int fromIndexInclusive, int toIndexExclusive) {
        this.variableDescriptor = variableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.combinedList = combinedList;
        this.fromIndexInclusive = fromIndexInclusive;
        this.toIndexExclusive = toIndexExclusive;
    }

    FlipSublistAction createUndoMove() {
        return new FlipSublistAction(this.variableDescriptor, this.inverseVariableSupply, this.combinedList, this.fromIndexInclusive, this.toIndexExclusive);
    }

    public KOptAffectedElements getAffectedElements() {
        if (this.fromIndexInclusive < this.toIndexExclusive) {
            return KOptAffectedElements.forMiddleRange(this.fromIndexInclusive, this.toIndexExclusive);
        }
        return KOptAffectedElements.forWrappedRange(this.fromIndexInclusive, this.toIndexExclusive);
    }

    MultipleDelegateList<Object> getCombinedList() {
        return this.combinedList;
    }

    void doMoveOnGenuineVariables() {
        FlipSublistAction.flipSublist(this.combinedList, this.fromIndexInclusive, this.toIndexExclusive);
    }

    public FlipSublistAction rebase(InnerScoreDirector<?, ?> destinationScoreDirector) {
        SingletonInverseVariableSupply newInverseVariableSupply = destinationScoreDirector.getSupplyManager().demand(new SingletonListInverseVariableDemand(this.variableDescriptor));
        return new FlipSublistAction(this.variableDescriptor, newInverseVariableSupply, this.combinedList.rebase(this.variableDescriptor, this.inverseVariableSupply, destinationScoreDirector), this.fromIndexInclusive, this.toIndexExclusive);
    }

    public static <T> void flipSublist(List<T> originalList, int fromIndexInclusive, int toIndexExclusive) {
        if (fromIndexInclusive < toIndexExclusive) {
            Collections.reverse(originalList.subList(fromIndexInclusive, toIndexExclusive));
        } else {
            List<T> firstHalfReversedPath = originalList.subList(fromIndexInclusive, originalList.size());
            List<T> secondHalfReversedPath = originalList.subList(0, toIndexExclusive);
            int totalLength = firstHalfReversedPath.size() + secondHalfReversedPath.size();
            for (int i = 0; i < totalLength >> 1; ++i) {
                if (i < firstHalfReversedPath.size()) {
                    if (i < secondHalfReversedPath.size()) {
                        int secondHalfIndex = secondHalfReversedPath.size() - i - 1;
                        T savedFirstItem = firstHalfReversedPath.get(i);
                        firstHalfReversedPath.set(i, secondHalfReversedPath.get(secondHalfIndex));
                        secondHalfReversedPath.set(secondHalfIndex, savedFirstItem);
                        continue;
                    }
                    int secondIndex = firstHalfReversedPath.size() - i + secondHalfReversedPath.size() - 1;
                    T savedFirstItem = firstHalfReversedPath.get(i);
                    firstHalfReversedPath.set(i, firstHalfReversedPath.get(secondIndex));
                    firstHalfReversedPath.set(secondIndex, savedFirstItem);
                    continue;
                }
                int firstIndex = i - firstHalfReversedPath.size();
                int secondIndex = secondHalfReversedPath.size() - i - 1;
                T savedFirstItem = secondHalfReversedPath.get(firstIndex);
                secondHalfReversedPath.set(firstIndex, secondHalfReversedPath.get(secondIndex));
                secondHalfReversedPath.set(secondIndex, savedFirstItem);
            }
        }
    }

    public String toString() {
        return "FlipSublistAction(from=" + this.fromIndexInclusive + ", to=" + this.toIndexExclusive + ")";
    }
}

