/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list;

import java.util.Iterator;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.list.DestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.SubListSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.RandomSubListChangeMoveIterator;

public class RandomSubListChangeMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final SubListSelector<Solution_> subListSelector;
    private final DestinationSelector<Solution_> destinationSelector;
    private final boolean selectReversingMoveToo;

    public RandomSubListChangeMoveSelector(SubListSelector<Solution_> subListSelector, DestinationSelector<Solution_> destinationSelector, boolean selectReversingMoveToo) {
        this.subListSelector = subListSelector;
        this.destinationSelector = destinationSelector;
        this.selectReversingMoveToo = selectReversingMoveToo;
        this.phaseLifecycleSupport.addEventListener(subListSelector);
        this.phaseLifecycleSupport.addEventListener(destinationSelector);
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new RandomSubListChangeMoveIterator<Solution_>(this.subListSelector, this.destinationSelector, this.workingRandom, this.selectReversingMoveToo);
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return true;
    }

    @Override
    public long getSize() {
        long subListCount = this.subListSelector.getSize();
        long destinationCount = this.destinationSelector.getSize();
        return subListCount * destinationCount * (long)(this.selectReversingMoveToo ? 2 : 1);
    }

    boolean isSelectReversingMoveToo() {
        return this.selectReversingMoveToo;
    }

    SubListSelector<Solution_> getSubListSelector() {
        return this.subListSelector;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.subListSelector + ", " + this.destinationSelector + ")";
    }
}

