/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.list.mimic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.AbstractSelector;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.list.SubList;
import org.optaplanner.core.impl.heuristic.selector.list.SubListSelector;
import org.optaplanner.core.impl.heuristic.selector.list.mimic.MimicReplayingSubListSelector;
import org.optaplanner.core.impl.heuristic.selector.list.mimic.SubListMimicRecorder;

public class MimicRecordingSubListSelector<Solution_>
extends AbstractSelector<Solution_>
implements SubListMimicRecorder<Solution_>,
SubListSelector<Solution_> {
    protected final SubListSelector<Solution_> childSubListSelector;
    protected final List<MimicReplayingSubListSelector<Solution_>> replayingSubListSelectorList;

    public MimicRecordingSubListSelector(SubListSelector<Solution_> childSubListSelector) {
        this.childSubListSelector = childSubListSelector;
        this.phaseLifecycleSupport.addEventListener(childSubListSelector);
        this.replayingSubListSelectorList = new ArrayList<MimicReplayingSubListSelector<Solution_>>();
    }

    @Override
    public void addMimicReplayingSubListSelector(MimicReplayingSubListSelector<Solution_> replayingSubListSelector) {
        this.replayingSubListSelectorList.add(replayingSubListSelector);
    }

    @Override
    public ListVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.childSubListSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.childSubListSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childSubListSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.childSubListSelector.getSize();
    }

    @Override
    public Iterator<SubList> iterator() {
        return new RecordingSubListIterator(this.childSubListSelector.iterator());
    }

    @Override
    public Iterator<Object> endingValueIterator() {
        return this.childSubListSelector.endingValueIterator();
    }

    @Override
    public long getValueCount() {
        return this.childSubListSelector.getValueCount();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MimicRecordingSubListSelector that = (MimicRecordingSubListSelector)other;
        return Objects.equals(this.childSubListSelector, that.childSubListSelector) && Objects.equals(this.replayingSubListSelectorList.size(), that.replayingSubListSelectorList.size());
    }

    public int hashCode() {
        return Objects.hash(this.childSubListSelector, this.replayingSubListSelectorList.size());
    }

    public String toString() {
        return "Recording(" + this.childSubListSelector + ")";
    }

    private class RecordingSubListIterator
    extends SelectionIterator<SubList> {
        private final Iterator<SubList> childSubListIterator;

        public RecordingSubListIterator(Iterator<SubList> childSubListIterator) {
            this.childSubListIterator = childSubListIterator;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.childSubListIterator.hasNext();
            for (MimicReplayingSubListSelector replayingValueSelector : MimicRecordingSubListSelector.this.replayingSubListSelectorList) {
                replayingValueSelector.recordedHasNext(hasNext);
            }
            return hasNext;
        }

        @Override
        public SubList next() {
            SubList next = this.childSubListIterator.next();
            for (MimicReplayingSubListSelector replayingValueSelector : MimicRecordingSubListSelector.this.replayingSubListSelectorList) {
                replayingValueSelector.recordedNext(next);
            }
            return next;
        }
    }
}

