/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import java.util.Objects;
import java.util.Random;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;

public final class ParabolicDistributionNearbyRandom
implements NearbyRandom {
    private final int sizeMaximum;

    public ParabolicDistributionNearbyRandom(int sizeMaximum) {
        this.sizeMaximum = sizeMaximum;
        if (sizeMaximum < 1) {
            throw new IllegalArgumentException("The maximum (" + sizeMaximum + ") must be at least 1.");
        }
    }

    @Override
    public int nextInt(Random random, int nearbySize) {
        double p;
        int m = this.sizeMaximum <= nearbySize ? this.sizeMaximum : nearbySize;
        double x = (double)m * (1.0 - Math.pow(1.0 - (p = random.nextDouble()), 0.3333333333333333));
        int next = (int)x;
        if (next >= m) {
            next = m - 1;
        }
        return next;
    }

    @Override
    public int getOverallSizeMaximum() {
        return this.sizeMaximum;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ParabolicDistributionNearbyRandom that = (ParabolicDistributionNearbyRandom)other;
        return this.sizeMaximum == that.sizeMaximum;
    }

    public int hashCode() {
        return Objects.hash(this.sizeMaximum);
    }
}

