/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.constraint;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.stream.ConstraintJustification;
import org.optaplanner.core.api.score.stream.DefaultConstraintJustification;

public final class ConstraintMatch<Score_ extends Score<Score_>>
implements Comparable<ConstraintMatch<Score_>> {
    private final String constraintPackage;
    private final String constraintName;
    private final String constraintId;
    private final ConstraintJustification justification;
    private final List<Object> indictedObjects;
    private final Score_ score;

    @Deprecated(forRemoval=true)
    public ConstraintMatch(String constraintPackage, String constraintName, List<Object> justificationList, Score_ score) {
        this(constraintPackage, constraintName, DefaultConstraintJustification.of(score, justificationList), justificationList, score);
    }

    public ConstraintMatch(String constraintPackage, String constraintName, ConstraintJustification justification, Collection<Object> indictedObjects, Score_ score) {
        this.constraintPackage = Objects.requireNonNull(constraintPackage);
        this.constraintName = Objects.requireNonNull(constraintName);
        this.constraintId = ConstraintMatchTotal.composeConstraintId(constraintPackage, constraintName);
        this.justification = Objects.requireNonNull(justification);
        this.indictedObjects = Objects.requireNonNull(indictedObjects) instanceof List ? (List<Object>)indictedObjects : List.copyOf(indictedObjects);
        this.score = (Score)Objects.requireNonNull(score);
    }

    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    @Deprecated(forRemoval=true)
    public List<Object> getJustificationList() {
        if (this.justification instanceof DefaultConstraintJustification) {
            return ((DefaultConstraintJustification)this.justification).getFacts();
        }
        throw new IllegalStateException("Cannot retrieve list of facts from a custom constraint justification (" + this.justification + ").\nUse ConstraintMatch#getJustification() method instead.");
    }

    public <Justification_ extends ConstraintJustification> Justification_ getJustification() {
        return (Justification_)this.justification;
    }

    public List<Object> getIndictedObjectList() {
        return this.indictedObjects;
    }

    public Score_ getScore() {
        return this.score;
    }

    public String getConstraintId() {
        return ConstraintMatchTotal.composeConstraintId(this.constraintPackage, this.constraintName);
    }

    public String getIdentificationString() {
        return this.getConstraintId() + "/" + this.justification;
    }

    @Override
    public int compareTo(ConstraintMatch<Score_> other) {
        if (!this.constraintId.equals(other.constraintId)) {
            return this.constraintId.compareTo(other.constraintId);
        }
        if (!this.score.equals(other.score)) {
            return this.score.compareTo(other.score);
        }
        if (this.justification instanceof Comparable) {
            return ((Comparable)((Object)this.justification)).compareTo(other.justification);
        }
        return Integer.compare(System.identityHashCode(this.justification), System.identityHashCode(other.justification));
    }

    public String toString() {
        return this.getIdentificationString() + "=" + this.score;
    }
}

