/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt;

import java.util.Iterator;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableDemand;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptListMoveIterator;
import org.optaplanner.core.impl.heuristic.selector.move.generic.list.kopt.KOptUtils;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.solver.scope.SolverScope;

final class KOptListMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final EntityIndependentValueSelector<Solution_> originSelector;
    private final EntityIndependentValueSelector<Solution_> valueSelector;
    private final int minK;
    private final int maxK;
    private final int[] pickedKDistribution;
    private SingletonInverseVariableSupply inverseVariableSupply;
    private IndexVariableSupply indexVariableSupply;

    public KOptListMoveSelector(ListVariableDescriptor<Solution_> listVariableDescriptor, EntityIndependentValueSelector<Solution_> originSelector, EntityIndependentValueSelector<Solution_> valueSelector, int minK, int maxK, int[] pickedKDistribution) {
        this.listVariableDescriptor = listVariableDescriptor;
        this.originSelector = originSelector;
        this.valueSelector = valueSelector;
        this.minK = minK;
        this.maxK = maxK;
        this.pickedKDistribution = pickedKDistribution;
        this.phaseLifecycleSupport.addEventListener(originSelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.inverseVariableSupply = supplyManager.demand(new SingletonListInverseVariableDemand<Solution_>(this.listVariableDescriptor));
        this.indexVariableSupply = supplyManager.demand(new IndexVariableDemand<Solution_>(this.listVariableDescriptor));
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.indexVariableSupply = null;
    }

    @Override
    public long getSize() {
        long total = 0L;
        long valueSelectorSize = this.valueSelector.getSize();
        int i = this.minK;
        while ((long)i < Math.min(valueSelectorSize, (long)this.maxK)) {
            if (valueSelectorSize > (long)i) {
                long kOptMoveTypes = KOptUtils.getPureKOptMoveTypes(i);
                long edgeChoices = valueSelectorSize <= Integer.MAX_VALUE ? CombinatoricsUtils.binomialCoefficient((int)((int)(valueSelectorSize - 1L)), (int)i) : Long.MAX_VALUE;
                total += kOptMoveTypes * edgeChoices;
            }
            ++i;
        }
        return total;
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new KOptListMoveIterator<Solution_, Solution_>(this.workingRandom, this.listVariableDescriptor, this.inverseVariableSupply, this.indexVariableSupply, this.originSelector, this.valueSelector, this.minK, this.maxK, this.pickedKDistribution);
    }

    @Override
    public boolean isCountable() {
        return false;
    }

    @Override
    public boolean isNeverEnding() {
        return true;
    }
}

