/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.definition;

import org.optaplanner.core.api.score.IBendableScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.score.definition.AbstractScoreDefinition;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public abstract class AbstractBendableScoreDefinition<Score_ extends Score<Score_>>
extends AbstractScoreDefinition<Score_>
implements ScoreDefinition<Score_> {
    protected final int hardLevelsSize;
    protected final int softLevelsSize;

    protected static String[] generateLevelLabels(int hardLevelsSize, int softLevelsSize) {
        if (hardLevelsSize < 0 || softLevelsSize < 0) {
            throw new IllegalArgumentException("The hardLevelsSize (" + hardLevelsSize + ") and softLevelsSize (" + softLevelsSize + ") should be positive.");
        }
        String[] levelLabels = new String[hardLevelsSize + softLevelsSize];
        for (int i = 0; i < levelLabels.length; ++i) {
            String labelPrefix = i < hardLevelsSize ? "hard " + i : "soft " + (i - hardLevelsSize);
            levelLabels[i] = labelPrefix + " score";
        }
        return levelLabels;
    }

    public AbstractBendableScoreDefinition(int hardLevelsSize, int softLevelsSize) {
        super(AbstractBendableScoreDefinition.generateLevelLabels(hardLevelsSize, softLevelsSize));
        this.hardLevelsSize = hardLevelsSize;
        this.softLevelsSize = softLevelsSize;
    }

    public int getHardLevelsSize() {
        return this.hardLevelsSize;
    }

    public int getSoftLevelsSize() {
        return this.softLevelsSize;
    }

    @Override
    public int getLevelsSize() {
        return this.hardLevelsSize + this.softLevelsSize;
    }

    @Override
    public int getFeasibleLevelsSize() {
        return this.hardLevelsSize;
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score score) {
        if (super.isCompatibleArithmeticArgument(score)) {
            IBendableScore bendableScore = (IBendableScore)score;
            return this.getLevelsSize() == bendableScore.levelsSize() && this.getHardLevelsSize() == bendableScore.hardLevelsSize() && this.getSoftLevelsSize() == bendableScore.softLevelsSize();
        }
        return false;
    }
}

