/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.function;

import java.util.Objects;

@FunctionalInterface
public interface TriPredicate<A, B, C> {
    public boolean test(A var1, B var2, C var3);

    default public TriPredicate<A, B, C> and(TriPredicate<? super A, ? super B, ? super C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> this.test(a, b, c) && other.test(a, b, c);
    }

    default public TriPredicate<A, B, C> negate() {
        return (a, b, c) -> !this.test(a, b, c);
    }

    default public TriPredicate<A, B, C> or(TriPredicate<? super A, ? super B, ? super C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> this.test(a, b, c) || other.test(a, b, c);
    }
}

