/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.memoryuse;

import org.optaplanner.benchmark.impl.statistic.StatisticPoint;

public class MemoryUseStatisticPoint
extends StatisticPoint {
    private final long timeMillisSpent;
    private final long usedMemory;
    private final long maxMemory;

    public static MemoryUseStatisticPoint create(long timeMillisSpent) {
        Runtime runtime = Runtime.getRuntime();
        return new MemoryUseStatisticPoint(timeMillisSpent, runtime.totalMemory() - runtime.freeMemory(), runtime.maxMemory());
    }

    public MemoryUseStatisticPoint(long timeMillisSpent, long usedMemory, long maxMemory) {
        this.timeMillisSpent = timeMillisSpent;
        this.usedMemory = usedMemory;
        this.maxMemory = maxMemory;
    }

    public long getTimeMillisSpent() {
        return this.timeMillisSpent;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    @Override
    public String toCsvLine() {
        return MemoryUseStatisticPoint.buildCsvLineWithLongs(this.timeMillisSpent, this.usedMemory, this.maxMemory);
    }
}

