/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.web.service.SharedWebContainerContext;
import org.ops4j.pax.web.service.spi.util.Path;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSharedWebContainerContext
implements SharedWebContainerContext {
    private Queue<Bundle> bundles = new ConcurrentLinkedQueue<Bundle>();
    private static final Log LOG = LogFactory.getLog(DefaultSharedWebContainerContext.class);

    @Override
    public boolean registerBundle(Bundle bundle) {
        if (!this.bundles.contains(bundle)) {
            this.bundles.add(bundle);
            return true;
        }
        return false;
    }

    @Override
    public boolean deregisterBundle(Bundle bundle) {
        return this.bundles.remove(bundle);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        for (Bundle bundle : this.bundles) {
            Set<String> paths = this.getResourcePaths(bundle, path);
            if (paths == null) continue;
            return paths;
        }
        return null;
    }

    @Override
    public String getMimeType(String arg0) {
        return null;
    }

    @Override
    public URL getResource(String path) {
        for (Bundle bundle : this.bundles) {
            URL pathUrl = this.getResource(bundle, path);
            if (pathUrl == null) continue;
            return pathUrl;
        }
        return null;
    }

    private URL getResource(Bundle bundle, String name) {
        String normalizedname = Path.normalizeResourcePath(name);
        LOG.debug("Searching bundle [" + bundle + "] for resource [" + normalizedname + "]");
        return bundle.getResource(normalizedname);
    }

    private Set<String> getResourcePaths(Bundle bundle, String name) {
        String normalizedname = Path.normalizeResourcePath(name);
        LOG.debug("Searching bundle [" + bundle + "] for resource paths of [" + normalizedname + "]");
        Enumeration entryPaths = bundle.getEntryPaths(normalizedname);
        if (entryPaths == null || !entryPaths.hasMoreElements()) {
            return null;
        }
        HashSet<String> foundPaths = new HashSet<String>();
        while (entryPaths.hasMoreElements()) {
            foundPaths.add((String)entryPaths.nextElement());
        }
        return foundPaths;
    }

    @Override
    public boolean handleSecurity(HttpServletRequest arg0, HttpServletResponse arg1) throws IOException {
        return true;
    }
}

