/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.validation;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.validation.ValidationResult;
import org.operaton.bpm.model.xml.validation.ValidationResultFormatter;
import org.operaton.bpm.model.xml.validation.ValidationResults;

public class ModelValidationResultsImpl
implements ValidationResults {
    protected Map<ModelElementInstance, List<ValidationResult>> collectedResults;
    protected int errorCount;
    protected int warningCount;

    public ModelValidationResultsImpl(Map<ModelElementInstance, List<ValidationResult>> collectedResults, int errorCount, int warningCount) {
        this.collectedResults = collectedResults;
        this.errorCount = errorCount;
        this.warningCount = warningCount;
    }

    public ModelValidationResultsImpl(ValidationResults ... validationResults) {
        this.collectedResults = new HashMap<ModelElementInstance, List<ValidationResult>>();
        for (ValidationResults entry : validationResults) {
            this.collectedResults.putAll(entry.getResults());
            this.errorCount += entry.getErrorCount();
            this.warningCount += entry.getWarinigCount();
        }
    }

    @Override
    public boolean hasErrors() {
        return this.errorCount > 0;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public int getWarinigCount() {
        return this.warningCount;
    }

    @Override
    public void write(StringWriter writer, ValidationResultFormatter formatter) {
        for (Map.Entry<ModelElementInstance, List<ValidationResult>> entry : this.collectedResults.entrySet()) {
            ModelElementInstance element = entry.getKey();
            List<ValidationResult> results = entry.getValue();
            formatter.formatElement(writer, element);
            for (ValidationResult result : results) {
                formatter.formatResult(writer, result);
            }
        }
    }

    @Override
    public void write(StringWriter writer, ValidationResultFormatter formatter, int maxSize) {
        int printedCount = 0;
        int previousLength = 0;
        for (Map.Entry<ModelElementInstance, List<ValidationResult>> entry : this.collectedResults.entrySet()) {
            ModelElementInstance element = entry.getKey();
            List<ValidationResult> results = entry.getValue();
            formatter.formatElement(writer, element);
            for (ValidationResult result : results) {
                formatter.formatResult(writer, result);
                int currentSize = writer.getBuffer().toString().getBytes().length;
                int currentLength = writer.getBuffer().length();
                if (!this.canAccommodateResult(maxSize, currentSize, printedCount, formatter)) {
                    writer.getBuffer().setLength(previousLength);
                    int remaining = this.errorCount + this.warningCount - printedCount;
                    formatter.formatSuffixWithOmittedResultsCount(writer, remaining);
                    return;
                }
                ++printedCount;
                previousLength = currentLength;
            }
        }
    }

    private boolean canAccommodateResult(int maxSize, int currentSize, int printedCount, ValidationResultFormatter formatter) {
        boolean isLastItemToPrint;
        boolean bl = isLastItemToPrint = printedCount == this.errorCount + this.warningCount - 1;
        if (isLastItemToPrint && currentSize <= maxSize) {
            return true;
        }
        int remaining = this.errorCount + this.warningCount - printedCount;
        int suffixLength = formatter.getFormattedSuffixWithOmittedResultsSize(remaining);
        return currentSize + suffixLength <= maxSize;
    }

    @Override
    public Map<ModelElementInstance, List<ValidationResult>> getResults() {
        return this.collectedResults;
    }
}

