/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.instance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.operaton.bpm.model.xml.Model;
import org.operaton.bpm.model.xml.ModelBuilder;
import org.operaton.bpm.model.xml.ModelException;
import org.operaton.bpm.model.xml.impl.ModelInstanceImpl;
import org.operaton.bpm.model.xml.impl.instance.ModelTypeInstanceContext;
import org.operaton.bpm.model.xml.impl.type.ModelElementTypeImpl;
import org.operaton.bpm.model.xml.impl.type.attribute.AttributeImpl;
import org.operaton.bpm.model.xml.impl.type.reference.ReferenceImpl;
import org.operaton.bpm.model.xml.impl.util.ModelUtil;
import org.operaton.bpm.model.xml.instance.DomElement;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.ModelElementType;
import org.operaton.bpm.model.xml.type.ModelElementTypeBuilder;
import org.operaton.bpm.model.xml.type.attribute.Attribute;
import org.operaton.bpm.model.xml.type.reference.Reference;

public class ModelElementInstanceImpl
implements ModelElementInstance {
    protected final ModelInstanceImpl modelInstance;
    private final DomElement domElement;
    private final ModelElementTypeImpl elementType;

    public static void registerType(ModelBuilder modelBuilder) {
        ModelElementTypeBuilder typeBuilder = modelBuilder.defineType(ModelElementInstance.class, "").abstractType();
        typeBuilder.build();
    }

    public ModelElementInstanceImpl(ModelTypeInstanceContext instanceContext) {
        this.domElement = instanceContext.domElement();
        this.modelInstance = instanceContext.model();
        this.elementType = instanceContext.modelType();
    }

    @Override
    public DomElement getDomElement() {
        return this.domElement;
    }

    @Override
    public ModelInstanceImpl getModelInstance() {
        return this.modelInstance;
    }

    @Override
    public ModelElementInstance getParentElement() {
        DomElement parentElement = this.domElement.getParentElement();
        if (parentElement != null) {
            return ModelUtil.getModelElement(parentElement, this.modelInstance);
        }
        return null;
    }

    @Override
    public ModelElementType getElementType() {
        return this.elementType;
    }

    @Override
    public String getAttributeValue(String attributeName) {
        return this.domElement.getAttribute(attributeName);
    }

    @Override
    public String getAttributeValueNs(String namespaceUri, String attributeName) {
        return this.domElement.getAttribute(namespaceUri, attributeName);
    }

    @Override
    public void setAttributeValue(String attributeName, String xmlValue) {
        this.setAttributeValue(attributeName, xmlValue, false, true);
    }

    @Override
    public void setAttributeValue(String attributeName, String xmlValue, boolean isIdAttribute) {
        this.setAttributeValue(attributeName, xmlValue, isIdAttribute, true);
    }

    @Override
    public void setAttributeValue(String attributeName, String xmlValue, boolean isIdAttribute, boolean withReferenceUpdate) {
        String oldValue = this.getAttributeValue(attributeName);
        if (isIdAttribute) {
            this.domElement.setIdAttribute(attributeName, xmlValue);
        } else {
            this.domElement.setAttribute(attributeName, xmlValue);
        }
        Attribute<?> attribute = this.elementType.getAttribute(attributeName);
        if (attribute != null && withReferenceUpdate) {
            ((AttributeImpl)attribute).updateIncomingReferences(this, xmlValue, oldValue);
        }
    }

    @Override
    public void setAttributeValueNs(String namespaceUri, String attributeName, String xmlValue) {
        this.setAttributeValueNs(namespaceUri, attributeName, xmlValue, false, true);
    }

    @Override
    public void setAttributeValueNs(String namespaceUri, String attributeName, String xmlValue, boolean isIdAttribute) {
        this.setAttributeValueNs(namespaceUri, attributeName, xmlValue, isIdAttribute, true);
    }

    @Override
    public void setAttributeValueNs(String namespaceUri, String attributeName, String xmlValue, boolean isIdAttribute, boolean withReferenceUpdate) {
        String namespaceForSetting = this.determineNamespace(namespaceUri, attributeName);
        String oldValue = this.getAttributeValueNs(namespaceForSetting, attributeName);
        if (isIdAttribute) {
            this.domElement.setIdAttribute(namespaceForSetting, attributeName, xmlValue);
        } else {
            this.domElement.setAttribute(namespaceForSetting, attributeName, xmlValue);
        }
        Attribute<?> attribute = this.elementType.getAttribute(attributeName);
        if (attribute != null && withReferenceUpdate) {
            ((AttributeImpl)attribute).updateIncomingReferences(this, xmlValue, oldValue);
        }
    }

    private String determineNamespace(String intendedNamespace, String attributeName) {
        boolean isSetInIntendedNamespace;
        boolean bl = isSetInIntendedNamespace = this.getAttributeValueNs(intendedNamespace, attributeName) != null;
        if (isSetInIntendedNamespace) {
            return intendedNamespace;
        }
        Set<String> alternativeNamespaces = this.modelInstance.getModel().getAlternativeNamespaces(intendedNamespace);
        if (alternativeNamespaces != null) {
            for (String alternativeNamespace : alternativeNamespaces) {
                if (this.getAttributeValueNs(alternativeNamespace, attributeName) == null) continue;
                return alternativeNamespace;
            }
        }
        return intendedNamespace;
    }

    @Override
    public void removeAttribute(String attributeName) {
        Object identifier;
        Attribute<?> attribute = this.elementType.getAttribute(attributeName);
        if (attribute != null && (identifier = attribute.getValue(this)) != null) {
            ((AttributeImpl)attribute).unlinkReference(this, identifier);
        }
        this.domElement.removeAttribute(attributeName);
    }

    @Override
    public void removeAttributeNs(String namespaceUri, String attributeName) {
        Object identifier;
        Attribute<?> attribute = this.elementType.getAttribute(attributeName);
        if (attribute != null && (identifier = attribute.getValue(this)) != null) {
            ((AttributeImpl)attribute).unlinkReference(this, identifier);
        }
        this.domElement.removeAttribute(namespaceUri, attributeName);
    }

    @Override
    public String getTextContent() {
        return this.getRawTextContent().trim();
    }

    @Override
    public void setTextContent(String textContent) {
        this.domElement.setTextContent(textContent);
    }

    @Override
    public String getRawTextContent() {
        return this.domElement.getTextContent();
    }

    @Override
    public ModelElementInstance getUniqueChildElementByNameNs(String namespaceUri, String elementName) {
        Model model = this.modelInstance.getModel();
        List<DomElement> childElements = this.domElement.getChildElementsByNameNs(this.asSet(namespaceUri, model.getAlternativeNamespaces(namespaceUri)), elementName);
        if (!childElements.isEmpty()) {
            return ModelUtil.getModelElement(childElements.get(0), this.modelInstance);
        }
        return null;
    }

    @Override
    public ModelElementInstance getUniqueChildElementByType(Class<? extends ModelElementInstance> elementType) {
        List<DomElement> childElements = this.domElement.getChildElementsByType(this.modelInstance, elementType);
        if (!childElements.isEmpty()) {
            return ModelUtil.getModelElement(childElements.get(0), this.modelInstance);
        }
        return null;
    }

    @Override
    public void setUniqueChildElementByNameNs(ModelElementInstance newChild) {
        ModelUtil.ensureInstanceOf(newChild, ModelElementInstanceImpl.class);
        ModelElementInstanceImpl newChildElement = (ModelElementInstanceImpl)newChild;
        DomElement childElement = newChildElement.getDomElement();
        ModelElementInstance existingChild = this.getUniqueChildElementByNameNs(childElement.getNamespaceURI(), childElement.getLocalName());
        if (existingChild == null) {
            this.addChildElement(newChild);
        } else {
            this.replaceChildElement(existingChild, newChildElement);
        }
    }

    @Override
    public void replaceChildElement(ModelElementInstance existingChild, ModelElementInstance newChild) {
        DomElement existingChildDomElement = existingChild.getDomElement();
        DomElement newChildDomElement = newChild.getDomElement();
        ((ModelElementInstanceImpl)existingChild).unlinkAllChildReferences();
        this.updateIncomingReferences(existingChild, newChild);
        this.domElement.replaceChild(newChildDomElement, existingChildDomElement);
        newChild.updateAfterReplacement();
    }

    private void updateIncomingReferences(ModelElementInstance oldInstance, ModelElementInstance newInstance) {
        String oldId = oldInstance.getAttributeValue("id");
        String newId = newInstance.getAttributeValue("id");
        if (oldId == null || newId == null) {
            return;
        }
        Collection<Attribute<?>> attributes = ((ModelElementTypeImpl)oldInstance.getElementType()).getAllAttributes();
        for (Attribute<?> attribute : attributes) {
            if (!attribute.isIdAttribute()) continue;
            for (Reference<?> incomingReference : attribute.getIncomingReferences()) {
                ((ReferenceImpl)incomingReference).referencedElementUpdated(newInstance, oldId, newId);
            }
        }
    }

    @Override
    public void replaceWithElement(ModelElementInstance newElement) {
        ModelElementInstanceImpl parentElement = (ModelElementInstanceImpl)this.getParentElement();
        if (parentElement == null) {
            throw new ModelException("Unable to remove replace without parent");
        }
        parentElement.replaceChildElement(this, newElement);
    }

    @Override
    public void addChildElement(ModelElementInstance newChild) {
        ModelUtil.ensureInstanceOf(newChild, ModelElementInstanceImpl.class);
        ModelElementInstance elementToInsertAfter = this.findElementToInsertAfter(newChild);
        this.insertElementAfter(newChild, elementToInsertAfter);
    }

    @Override
    public boolean removeChildElement(ModelElementInstance child) {
        ModelElementInstanceImpl childImpl = (ModelElementInstanceImpl)child;
        childImpl.unlinkAllReferences();
        childImpl.unlinkAllChildReferences();
        return this.domElement.removeChild(child.getDomElement());
    }

    @Override
    public Collection<ModelElementInstance> getChildElementsByType(ModelElementType childElementType) {
        ArrayList<ModelElementInstance> instances = new ArrayList<ModelElementInstance>();
        for (ModelElementType extendingType : childElementType.getExtendingTypes()) {
            instances.addAll(this.getChildElementsByType(extendingType));
        }
        Model model = this.modelInstance.getModel();
        Set<String> alternativeNamespaces = model.getAlternativeNamespaces(childElementType.getTypeNamespace());
        List<DomElement> elements = this.domElement.getChildElementsByNameNs(this.asSet(childElementType.getTypeNamespace(), alternativeNamespaces), childElementType.getTypeName());
        instances.addAll(ModelUtil.getModelElementCollection(elements, this.modelInstance));
        return instances;
    }

    @Override
    public <T extends ModelElementInstance> Collection<T> getChildElementsByType(Class<T> childElementClass) {
        return this.getChildElementsByType(this.getModelInstance().getModel().getType(childElementClass));
    }

    private ModelElementInstance findElementToInsertAfter(ModelElementInstance elementToInsert) {
        ModelElementInstance childElement;
        int childElementTypeIndex;
        List<ModelElementType> childElementTypes = this.elementType.getAllChildElementTypes();
        List<DomElement> childDomElements = this.domElement.getChildElements();
        Collection childElements = ModelUtil.getModelElementCollection(childDomElements, this.modelInstance);
        ModelElementInstance insertAfterElement = null;
        int newElementTypeIndex = ModelUtil.getIndexOfElementType(elementToInsert, childElementTypes);
        Iterator iterator = childElements.iterator();
        while (iterator.hasNext() && newElementTypeIndex >= (childElementTypeIndex = ModelUtil.getIndexOfElementType(childElement = (ModelElementInstance)iterator.next(), childElementTypes))) {
            insertAfterElement = childElement;
        }
        return insertAfterElement;
    }

    @Override
    public void insertElementAfter(ModelElementInstance elementToInsert, ModelElementInstance insertAfterElement) {
        if (insertAfterElement == null || insertAfterElement.getDomElement() == null) {
            this.domElement.insertChildElementAfter(elementToInsert.getDomElement(), null);
        } else {
            this.domElement.insertChildElementAfter(elementToInsert.getDomElement(), insertAfterElement.getDomElement());
        }
    }

    @Override
    public void updateAfterReplacement() {
    }

    private void unlinkAllReferences() {
        Collection<Attribute<?>> attributes = this.elementType.getAllAttributes();
        for (Attribute<?> attribute : attributes) {
            Object identifier = attribute.getValue(this);
            if (identifier == null) continue;
            ((AttributeImpl)attribute).unlinkReference(this, identifier);
        }
    }

    private void unlinkAllChildReferences() {
        List<ModelElementType> childElementTypes = this.elementType.getAllChildElementTypes();
        for (ModelElementType type : childElementTypes) {
            Collection<ModelElementInstance> childElementsForType = this.getChildElementsByType(type);
            for (ModelElementInstance childElement : childElementsForType) {
                ((ModelElementInstanceImpl)childElement).unlinkAllReferences();
            }
        }
    }

    protected <T> Set<T> asSet(T element, Set<T> elements) {
        HashSet<T> result = new HashSet<T>();
        result.add(element);
        if (elements != null) {
            result.addAll(elements);
        }
        return result;
    }

    public int hashCode() {
        return this.domElement.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ModelElementInstanceImpl)) {
            return false;
        }
        ModelElementInstanceImpl other = (ModelElementInstanceImpl)obj;
        return other.domElement.equals(this.domElement);
    }
}

