/*
 * Decompiled with CFR 0.152.
 */
package org.openyolo.protocol.internal;

import org.openyolo.protocol.MalformedDataException;
import org.openyolo.protocol.Protobufs;
import org.openyolo.protocol.TokenRequestInfo;
import org.openyolo.protocol.internal.ValueConverter;

public final class TokenRequestInfoConverters {
    public static final ValueConverter<Protobufs.TokenRequestInfo, TokenRequestInfo> PROTOBUF_TO_OBJECT = new ProtobufToObjectConverter();
    public static final ValueConverter<TokenRequestInfo, Protobufs.TokenRequestInfo> OBJECT_TO_PROTOBUF = new ObjectToProtobufConverter();

    private TokenRequestInfoConverters() {
        throw new IllegalStateException("not intended to be constructed");
    }

    private static final class ObjectToProtobufConverter
    implements ValueConverter<TokenRequestInfo, Protobufs.TokenRequestInfo> {
        private ObjectToProtobufConverter() {
        }

        @Override
        public Protobufs.TokenRequestInfo convert(TokenRequestInfo value) {
            return value.toProtobuf();
        }
    }

    private static final class ProtobufToObjectConverter
    implements ValueConverter<Protobufs.TokenRequestInfo, TokenRequestInfo> {
        private ProtobufToObjectConverter() {
        }

        @Override
        public TokenRequestInfo convert(Protobufs.TokenRequestInfo proto) {
            try {
                return TokenRequestInfo.fromProtobuf(proto);
            }
            catch (MalformedDataException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

